/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;

public abstract class IndexTemplateRegistry
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(IndexTemplateRegistry.class);
    protected final Settings settings;
    protected final Client client;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final ClusterService clusterService;
    protected final ConcurrentMap<String, AtomicBoolean> templateCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    protected final ConcurrentMap<String, AtomicBoolean> policyCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();

    public IndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        this.settings = nodeSettings;
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
    }

    public void initialize() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    protected List<IndexTemplateConfig> getLegacyTemplateConfigs() {
        return Collections.emptyList();
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        return Map.of();
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return Map.of();
    }

    protected List<LifecyclePolicy> getPolicyConfigs() {
        return Collections.emptyList();
    }

    protected abstract String getOrigin();

    protected void onPutTemplateFailure(String templateName, Exception e) {
        logger.error(() -> Strings.format((String)"error adding index template [%s] for [%s]", (Object[])new Object[]{templateName, this.getOrigin()}), (Throwable)e);
    }

    protected void onPutPolicyFailure(LifecyclePolicy policy, Exception e) {
        logger.error(() -> Strings.format((String)"error adding lifecycle policy [%s] for [%s]", (Object[])new Object[]{policy.getName(), this.getOrigin()}), (Throwable)e);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().getNodes().getMasterNode();
        if (masterNode == null) {
            return;
        }
        if (this.requiresMasterNode() && !state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        DiscoveryNode localNode = event.state().getNodes().getLocalNode();
        boolean localNodeVersionAfterMaster = localNode.getVersion().after(masterNode.getVersion());
        if (event.localNodeMaster() || localNodeVersionAfterMaster) {
            this.addTemplatesIfMissing(state);
            this.addIndexLifecyclePoliciesIfMissing(state);
        }
    }

    protected boolean requiresMasterNode() {
        return false;
    }

    private void addTemplatesIfMissing(ClusterState state) {
        this.addLegacyTemplatesIfMissing(state);
        this.addComponentTemplatesIfMissing(state);
        this.addComposableTemplatesIfMissing(state);
    }

    private void addLegacyTemplatesIfMissing(ClusterState state) {
        List<IndexTemplateConfig> indexTemplates = this.getLegacyTemplateConfigs();
        for (IndexTemplateConfig newTemplate : indexTemplates) {
            String templateName = newTemplate.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                IndexTemplateMetadata currentTemplate = (IndexTemplateMetadata)state.metadata().getTemplates().get(templateName);
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding legacy template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putLegacyTemplate(newTemplate, creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.getVersion()) || newTemplate.getVersion() > currentTemplate.getVersion()) {
                    logger.info("upgrading legacy template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.getVersion(), (Object)newTemplate.getVersion());
                    this.putLegacyTemplate(newTemplate, creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding legacy template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.getVersion());
                continue;
            }
            logger.trace("skipping the creation of legacy template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private void addComponentTemplatesIfMissing(ClusterState state) {
        Map<String, ComponentTemplate> indexTemplates = this.getComponentTemplateConfigs();
        for (Map.Entry<String, ComponentTemplate> newTemplate : indexTemplates.entrySet()) {
            String templateName = newTemplate.getKey();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                ComponentTemplate currentTemplate = (ComponentTemplate)state.metadata().componentTemplates().get(templateName);
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding component template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putComponentTemplate(templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.version()) || newTemplate.getValue().version() > currentTemplate.version()) {
                    logger.info("upgrading component template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version(), (Object)newTemplate.getValue().version());
                    this.putComponentTemplate(templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding component template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version());
                continue;
            }
            logger.trace("skipping the creation of component template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private void addComposableTemplatesIfMissing(ClusterState state) {
        Map<String, ComposableIndexTemplate> indexTemplates = this.getComposableTemplateConfigs();
        for (Map.Entry<String, ComposableIndexTemplate> newTemplate : indexTemplates.entrySet()) {
            String templateName = newTemplate.getKey();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                ComposableIndexTemplate currentTemplate = (ComposableIndexTemplate)state.metadata().templatesV2().get(templateName);
                boolean componentTemplatesAvailable = IndexTemplateRegistry.componentTemplatesExist(state, newTemplate.getValue());
                if (!componentTemplatesAvailable) {
                    creationCheck.set(false);
                    logger.trace("not adding composable template [{}] for [{}] because its required component templates do not exist", (Object)templateName, (Object)this.getOrigin());
                    continue;
                }
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding composable template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putComposableTemplate(templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.version()) || newTemplate.getValue().version() > currentTemplate.version()) {
                    logger.info("upgrading composable template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version(), (Object)newTemplate.getValue().version());
                    this.putComposableTemplate(templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding composable template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version());
                continue;
            }
            logger.trace("skipping the creation of composable template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private static boolean componentTemplatesExist(ClusterState state, ComposableIndexTemplate indexTemplate) {
        return state.metadata().componentTemplates().keySet().containsAll(indexTemplate.composedOf());
    }

    private void putLegacyTemplate(IndexTemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(config.loadBytes(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding legacy template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(templateName, e);
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putTemplate(arg_0, arg_1));
        });
    }

    private void putComponentTemplate(final String templateName, ComponentTemplate template, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutComponentTemplateAction.Request request = new PutComponentTemplateAction.Request(templateName).componentTemplate(template);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding component template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(templateName, e);
                }
            }, (req, listener) -> this.client.execute((ActionType)PutComponentTemplateAction.INSTANCE, (ActionRequest)req, listener));
        });
    }

    private void putComposableTemplate(final String templateName, ComposableIndexTemplate indexTemplate, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutComposableIndexTemplateAction.Request request = new PutComposableIndexTemplateAction.Request(templateName).indexTemplate(indexTemplate);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding composable template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(templateName, e);
                }
            }, (req, listener) -> this.client.execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)req, listener));
        });
    }

    private void addIndexLifecyclePoliciesIfMissing(ClusterState state) {
        Optional<IndexLifecycleMetadata> maybeMeta = Optional.ofNullable((IndexLifecycleMetadata)state.metadata().custom("index_lifecycle"));
        for (LifecyclePolicy policy : this.getPolicyConfigs()) {
            boolean policyNeedsToBeCreated;
            AtomicBoolean creationCheck = this.policyCreationsInProgress.computeIfAbsent(policy.getName(), key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            boolean bl = policyNeedsToBeCreated = !maybeMeta.flatMap(ilmMeta -> Optional.ofNullable(ilmMeta.getPolicies().get(policy.getName()))).isPresent();
            if (policyNeedsToBeCreated) {
                logger.debug("adding lifecycle policy [{}] for [{}], because it doesn't exist", (Object)policy.getName(), (Object)this.getOrigin());
                this.putPolicy(policy, creationCheck);
                continue;
            }
            logger.trace("not adding lifecycle policy [{}] for [{}], because it already exists", (Object)policy.getName(), (Object)this.getOrigin());
            creationCheck.set(false);
        }
    }

    private void putPolicy(final LifecyclePolicy policy, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutLifecycleAction.Request request = new PutLifecycleAction.Request(policy);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding lifecycle policy [{}] for [{}], request was not acknowledged", (Object)policy.getName(), (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutPolicyFailure(policy, e);
                }
            }, (req, listener) -> this.client.execute((ActionType)PutLifecycleAction.INSTANCE, (ActionRequest)req, listener));
        });
    }

    protected static Map<String, ComposableIndexTemplate> parseComposableTemplates(IndexTemplateConfig ... config) {
        return Arrays.stream(config).collect(Collectors.toUnmodifiableMap(IndexTemplateConfig::getTemplateName, indexTemplateConfig -> {
            try {
                return ComposableIndexTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, indexTemplateConfig.loadBytes()));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }));
    }
}

