/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public final class MultiShardTermsEnum {
    private final TermMergeQueue queue;
    private final TermsEnumWithCurrent[] top;
    private int numTop;
    private BytesRef current;

    public MultiShardTermsEnum(TermsEnum[] enums) throws IOException {
        this.queue = new TermMergeQueue(enums.length);
        this.top = new TermsEnumWithCurrent[enums.length];
        this.numTop = 0;
        this.queue.clear();
        for (int i = 0; i < enums.length; ++i) {
            TermsEnum termsEnum = enums[i];
            BytesRef term = termsEnum.next();
            if (term == null) continue;
            TermsEnumWithCurrent entry = new TermsEnumWithCurrent();
            entry.current = term;
            entry.terms = termsEnum;
            this.queue.add(entry);
        }
    }

    public BytesRef term() {
        return this.current;
    }

    private void pullTop() {
        assert (this.numTop == 0);
        this.numTop = this.queue.fillTop(this.top);
        this.current = this.top[0].current;
    }

    private void pushTop() throws IOException {
        for (int i = 0; i < this.numTop; ++i) {
            TermsEnumWithCurrent termsEnum = (TermsEnumWithCurrent)this.queue.top();
            termsEnum.current = termsEnum.terms.next();
            if (termsEnum.current == null) {
                this.queue.pop();
                continue;
            }
            this.queue.updateTop();
        }
        this.numTop = 0;
    }

    public BytesRef next() throws IOException {
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        return this.current;
    }

    public long docFreq() throws IOException {
        long sum = 0L;
        for (int i = 0; i < this.numTop; ++i) {
            sum += (long)this.top[i].terms.docFreq();
        }
        return sum;
    }

    private static final class TermMergeQueue
    extends PriorityQueue<TermsEnumWithCurrent> {
        final int[] stack;

        TermMergeQueue(int size) {
            super(size);
            this.stack = new int[size];
        }

        protected boolean lessThan(TermsEnumWithCurrent termsA, TermsEnumWithCurrent termsB) {
            return termsA.current.compareTo(termsB.current) < 0;
        }

        int fillTop(TermsEnumWithCurrent[] tops) {
            int size = this.size();
            if (size == 0) {
                return 0;
            }
            tops[0] = (TermsEnumWithCurrent)this.top();
            int numTop = 1;
            this.stack[0] = 1;
            int stackLen = 1;
            while (stackLen != 0) {
                int leftChild;
                int index = this.stack[--stackLen];
                int end = Math.min(size, leftChild + 1);
                for (int child = leftChild = index << 1; child <= end; ++child) {
                    TermsEnumWithCurrent te = this.get(child);
                    if (!te.current.equals((Object)tops[0].current)) continue;
                    tops[numTop++] = te;
                    this.stack[stackLen++] = child;
                }
            }
            return numTop;
        }

        private TermsEnumWithCurrent get(int i) {
            return (TermsEnumWithCurrent)this.getHeapArray()[i];
        }
    }

    static final class TermsEnumWithCurrent {
        TermsEnum terms;
        public BytesRef current;

        TermsEnumWithCurrent() {
        }
    }
}

