/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

class NodeTermsEnumResponse
extends TransportResponse {
    private String error;
    private boolean complete;
    private List<String> terms;
    private String nodeId;

    NodeTermsEnumResponse(StreamInput in) throws IOException {
        super(in);
        this.terms = in.getTransportVersion().before(TransportVersion.V_8_2_0) ? in.readList(r -> {
            String term = r.readString();
            in.readLong();
            return term;
        }) : in.readStringList();
        this.error = in.readOptionalString();
        this.complete = in.readBoolean();
        this.nodeId = in.readString();
    }

    NodeTermsEnumResponse(String nodeId, List<String> terms, String error, boolean complete) {
        this.nodeId = nodeId;
        this.terms = terms;
        this.error = error;
        this.complete = complete;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersion.V_8_2_0)) {
            out.writeCollection((Collection)this.terms.stream().map(term -> out1 -> {
                out1.writeString(term);
                out1.writeLong(1L);
            }).collect(Collectors.toList()));
        } else {
            out.writeStringCollection(this.terms);
        }
        out.writeOptionalString(this.error);
        out.writeBoolean(this.complete);
        out.writeString(this.nodeId);
    }

    public List<String> terms() {
        return this.terms;
    }

    public String getError() {
        return this.error;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

