/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension;

import com.sonar.sslr.api.RecognitionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.api.utils.Version;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonarsource.analyzer.commons.ProgressReport;

public abstract class IacSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(IacSensor.class);
    private static final Pattern EMPTY_FILE_CONTENT_PATTERN = Pattern.compile("\\s*+");
    private static final String FAIL_FAST_PROPERTY_NAME = "sonar.internal.analysis.failFast";
    protected final SonarRuntime sonarRuntime;
    protected final FileLinesContextFactory fileLinesContextFactory;
    protected final NoSonarFilter noSonarFilter;
    protected final Language language;

    protected IacSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, Language language) {
        this.sonarRuntime = sonarRuntime;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.language = language;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(this.language.getKey()).name("IaC " + this.language.getName() + " Sensor");
        if (this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)3))) {
            descriptor.processesFilesIndependently();
        }
    }

    protected abstract TreeParser<Tree> treeParser();

    protected abstract String repositoryKey();

    protected abstract List<TreeVisitor<InputFileContext>> visitors(SensorContext var1, DurationStatistics var2);

    protected abstract String getActivationSettingKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SensorContext sensorContext) {
        if (!this.isActive(sensorContext)) {
            return;
        }
        if (this.isNotSonarLintContext(sensorContext)) {
            this.importExternalReports(sensorContext);
        }
        DurationStatistics statistics = new DurationStatistics(sensorContext.config());
        List<InputFile> inputFiles = this.inputFiles(sensorContext);
        List<String> filenames = inputFiles.stream().map(InputFile::toString).collect(Collectors.toList());
        ProgressReport progressReport = new ProgressReport("Progress of the " + this.language.getName() + " analysis", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(filenames);
        boolean success = false;
        Analyzer analyzer = new Analyzer(this.treeParser(), this.visitors(sensorContext, statistics), statistics);
        try {
            success = analyzer.analyseFiles(sensorContext, inputFiles, progressReport);
        }
        finally {
            if (success) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
        statistics.log();
    }

    private List<InputFile> inputFiles(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicate predicate = this.mainFilePredicate(sensorContext);
        return StreamSupport.stream(fileSystem.inputFiles(predicate).spliterator(), false).collect(Collectors.toList());
    }

    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        return fileSystem.predicates().and(fileSystem.predicates().hasLanguage(this.language.getKey()), fileSystem.predicates().hasType(InputFile.Type.MAIN));
    }

    protected void importExternalReports(SensorContext sensorContext) {
    }

    protected boolean isNotSonarLintContext(SensorContext sensorContext) {
        return sensorContext.runtime().getProduct() != SonarProduct.SONARLINT;
    }

    protected ParseException toParseException(String action, InputFile inputFile, Exception cause) {
        TextPointer position = null;
        if (cause instanceof RecognitionException) {
            position = inputFile.newPointer(((RecognitionException)cause).getLine(), 0);
        }
        return ParseException.createGeneralParseException(action, inputFile, cause, position);
    }

    private boolean isActive(SensorContext sensorContext) {
        return sensorContext.config().getBoolean(this.getActivationSettingKey()).orElse(false);
    }

    private class Analyzer {
        private final TreeParser<Tree> parser;
        private final List<TreeVisitor<InputFileContext>> visitors;
        private final DurationStatistics statistics;

        public Analyzer(TreeParser<Tree> parser, List<TreeVisitor<InputFileContext>> visitors, DurationStatistics statistics) {
            this.parser = parser;
            this.visitors = visitors;
            this.statistics = statistics;
        }

        boolean analyseFiles(SensorContext sensorContext, List<InputFile> inputFiles, ProgressReport progressReport) {
            for (InputFile inputFile : inputFiles) {
                if (sensorContext.isCancelled()) {
                    return false;
                }
                InputFileContext inputFileContext = new InputFileContext(sensorContext, inputFile);
                try {
                    this.analyseFile(inputFileContext);
                }
                catch (ParseException e) {
                    this.logParsingError(e);
                    inputFileContext.reportParseError(IacSensor.this.repositoryKey(), e.getPosition());
                }
                progressReport.nextFile();
            }
            return true;
        }

        private void analyseFile(InputFileContext inputFileContext) {
            String content;
            InputFile inputFile = inputFileContext.inputFile;
            try {
                content = inputFile.contents();
            }
            catch (IOException | RuntimeException e) {
                throw IacSensor.this.toParseException("read", inputFile, e);
            }
            if (EMPTY_FILE_CONTENT_PATTERN.matcher(content).matches()) {
                return;
            }
            Tree tree = this.statistics.time("Parse", () -> {
                try {
                    return this.parser.parse(content, inputFileContext);
                }
                catch (ParseException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw IacSensor.this.toParseException("parse", inputFile, e);
                }
            });
            for (TreeVisitor<InputFileContext> visitor : this.visitors) {
                try {
                    String visitorId = visitor.getClass().getSimpleName();
                    this.statistics.time(visitorId, () -> visitor.scan(inputFileContext, tree));
                }
                catch (RuntimeException e) {
                    inputFileContext.reportAnalysisError(e.getMessage(), null);
                    LOG.error("Cannot analyse '" + inputFile + "': " + e.getMessage(), (Throwable)e);
                    this.interruptOnFailFast(inputFileContext.sensorContext, inputFile, e);
                }
            }
        }

        private void interruptOnFailFast(SensorContext context, InputFile inputFile, Exception e) {
            if (context.config().getBoolean(IacSensor.FAIL_FAST_PROPERTY_NAME).orElse(false).booleanValue()) {
                throw new IllegalStateException("Exception when analyzing '" + inputFile + "'", e);
            }
        }

        private void logParsingError(ParseException e) {
            LOG.error(e.getMessage());
            String detailedMessage = e.getDetails();
            if (detailedMessage != null) {
                LOG.debug(detailedMessage);
            }
            String stackTrace = this.getStackTrace(e);
            LOG.debug(stackTrace);
        }

        private String getStackTrace(ParseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            return sw.getBuffer().toString();
        }
    }
}

