/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.checks.utils.command.CommandPredicate;
import org.sonar.iac.docker.checks.utils.command.MultipleUnorderedOptionsPredicate;
import org.sonar.iac.docker.checks.utils.command.OptionPredicate;
import org.sonar.iac.docker.checks.utils.command.PredicateContext;
import org.sonar.iac.docker.checks.utils.command.SingularPredicate;
import org.sonar.iac.docker.symbols.ArgumentResolution;

public class CommandDetector {
    private final List<CommandPredicate> predicates;

    private CommandDetector(List<CommandPredicate> predicates) {
        this.predicates = predicates;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Command> search(List<ArgumentResolution> resolvedArguments) {
        ArrayList<Command> commands = new ArrayList<Command>();
        LinkedList<ArgumentResolution> argumentStack = new LinkedList<ArgumentResolution>(resolvedArguments);
        PredicateContext context = new PredicateContext(argumentStack, this.predicates);
        while (!argumentStack.isEmpty()) {
            List<ArgumentResolution> commandArguments = this.fullMatch(context);
            if (commandArguments.isEmpty()) continue;
            commands.add(new Command(commandArguments));
        }
        return commands;
    }

    public List<ArgumentResolution> fullMatch(PredicateContext context) {
        context.startNewfullMatchOn(context.getDetectorPredicates());
        while (context.arePredicatesToDetectLeft()) {
            context.provideNextPredicate();
            ArgumentResolution resolution = context.getNextArgumentToHandle();
            if (resolution == null) {
                return context.remainingPredicatesAreOptional() ? context.getArgumentsToReport() : Collections.emptyList();
            }
            if (resolution.isUnresolved()) {
                context.getNextArgumentToHandleAndRemoveFromList();
                return Collections.emptyList();
            }
            context.matchOnCurrentPredicate();
            if (!context.is(PredicateContext.Status.ABORT, PredicateContext.Status.FOUND_NO_PREDICATE_MATCH)) continue;
            return Collections.emptyList();
        }
        return context.getArgumentsToReport();
    }

    public static class Command
    implements HasTextRange {
        final List<ArgumentResolution> resolvedArguments;

        public Command(List<ArgumentResolution> resolvedArguments) {
            this.resolvedArguments = resolvedArguments;
        }

        @Override
        public TextRange textRange() {
            return TextRanges.mergeElementsWithTextRange(this.resolvedArguments.stream().map(ArgumentResolution::argument).collect(Collectors.toList()));
        }
    }

    public static class Builder {
        List<CommandPredicate> predicates = new ArrayList<CommandPredicate>();

        private void addCommandPredicate(CommandPredicate commandPredicate) {
            this.predicates.add(commandPredicate);
        }

        private void addSingularPredicate(Predicate<String> predicate, CommandPredicate.Type type) {
            this.addCommandPredicate(new SingularPredicate(predicate, type));
        }

        private void addOptionPredicate(SingularPredicate flag, SingularPredicate value) {
            this.addCommandPredicate(new OptionPredicate(flag, value));
        }

        private void addMultipleOptionsPredicate(List<OptionPredicate> expectedOptions) {
            this.addCommandPredicate(new MultipleUnorderedOptionsPredicate(expectedOptions));
        }

        public Builder with(Predicate<String> predicate) {
            this.addSingularPredicate(predicate, CommandPredicate.Type.MATCH);
            return this;
        }

        public Builder with(Collection<String> firstOf) {
            return this.with(firstOf::contains);
        }

        public Builder with(String expectedString) {
            return this.with(expectedString::equals);
        }

        public Builder withOptional(Predicate<String> predicate) {
            this.addSingularPredicate(predicate, CommandPredicate.Type.OPTIONAL);
            return this;
        }

        public Builder notWith(Predicate<String> predicate) {
            this.addSingularPredicate(predicate, CommandPredicate.Type.NO_MATCH);
            return this;
        }

        public Builder withOptionalRepeating(Predicate<String> predicate) {
            this.addSingularPredicate(predicate, CommandPredicate.Type.ZERO_OR_MORE);
            return this;
        }

        public Builder withOptionalRepeatingExcept(Predicate<String> predicate) {
            return this.withOptionalRepeating(predicate.negate());
        }

        public Builder withOptionalRepeatingExcept(String excludedString) {
            return this.withOptionalRepeatingExcept(excludedString::equals);
        }

        public Builder withOptionalRepeatingExcept(Collection<String> excludedStrings) {
            return this.withOptionalRepeatingExcept(excludedStrings::contains);
        }

        public Builder withAnyFlagExcept(String ... excludedFlags) {
            return this.withAnyFlagExcept(Arrays.asList(excludedFlags));
        }

        public Builder withAnyFlagExcept(Collection<String> excludedFlags) {
            return this.withOptionalRepeating(s -> s.startsWith("-") && !excludedFlags.contains(s)).notWith(excludedFlags::contains);
        }

        public Builder withAnyFlagFollowedBy(String ... flags) {
            return this.withAnyFlagFollowedBy(Arrays.asList(flags));
        }

        public Builder withAnyFlagFollowedBy(Collection<String> flags) {
            return this.withOptionalRepeating(s -> s.startsWith("-") && !flags.contains(s)).with(flags);
        }

        public Builder withAnyFlag() {
            return this.withOptionalRepeating(s -> s.startsWith("-"));
        }

        public Builder withAnyOptionExcluding(Collection<String> excludedFlags) {
            SingularPredicate flagPredicate = new SingularPredicate(s -> s.startsWith("-") && !excludedFlags.contains(s), CommandPredicate.Type.ZERO_OR_MORE);
            SingularPredicate valuePredicate = new SingularPredicate(s -> !s.startsWith("-") && !s.equals("&&") && !excludedFlags.contains(s), CommandPredicate.Type.ZERO_OR_MORE);
            this.addOptionPredicate(flagPredicate, valuePredicate);
            return this;
        }

        public Builder withMultipleUnorderedOptions(List<OptionPredicate> expectedOptions) {
            this.addMultipleOptionsPredicate(expectedOptions);
            return this;
        }

        public Builder withPredicatesFrom(Builder otherBuilder) {
            this.predicates.addAll(otherBuilder.predicates);
            return this;
        }

        public CommandDetector build() {
            return new CommandDetector(this.predicates);
        }
    }
}

