/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.common.yaml.YamlSensor;
import org.sonar.iac.kubernetes.checks.KubernetesCheckList;
import org.sonar.iac.kubernetes.plugin.KubernetesLanguage;

public class KubernetesSensor
extends YamlSensor {
    private static final String DIRECTIVE_IN_COMMENT = "#.*\\{\\{";
    private static final String DIRECTIVE_IN_SINGLE_QUOTE = "'[^']*\\{\\{[^']*'";
    private static final String DIRECTIVE_IN_DOUBLE_QUOTE = "\"[^\"]*\\{\\{[^\"]*\"";
    private static final String CODEFRESH_VARIABLES = "\\{\\{[\\w\\s]+}}";
    private static final Pattern HELM_DIRECTIVE_IN_COMMENT_OR_STRING = Pattern.compile("(" + String.join((CharSequence)"|", "#.*\\{\\{", "'[^']*\\{\\{[^']*'", "\"[^\"]*\\{\\{[^\"]*\"", "\\{\\{[\\w\\s]+}}") + ")");

    public KubernetesSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, KubernetesLanguage language) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, (Language)language, KubernetesCheckList.checks());
    }

    @Override
    protected String repositoryKey() {
        return "kubernetes";
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.kubernetes.activate";
    }

    @Override
    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        return new KubernetesFilePredicate();
    }

    static class KubernetesFilePredicate
    implements FilePredicate {
        private static final Pattern LINE_TERMINATOR = Pattern.compile("[\\n\\r\\u2028\\u2029]");
        private static final Set<String> IDENTIFIER = Set.of("apiVersion", "kind", "metadata", "spec");
        private static final Logger LOG = LoggerFactory.getLogger(KubernetesFilePredicate.class);
        private static final int DEFAULT_BUFFER_SIZE = 8192;

        KubernetesFilePredicate() {
        }

        public boolean apply(InputFile inputFile) {
            return KubernetesFilePredicate.hasKubernetesObjectStructure(inputFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean hasKubernetesObjectStructure(InputFile inputFile) {
            int identifierCount = 0;
            boolean hasExpectedIdentifier = false;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputFile.inputStream());){
                String[] lines;
                byte[] bytes = bufferedInputStream.readNBytes(8192);
                String text = new String(bytes, inputFile.charset());
                for (String line : lines = LINE_TERMINATOR.split(text)) {
                    if (IDENTIFIER.stream().anyMatch(line::startsWith)) {
                        ++identifierCount;
                    } else if ("---".equals(line)) {
                        identifierCount = 0;
                    } else if (line.contains("{{") && !HELM_DIRECTIVE_IN_COMMENT_OR_STRING.matcher(line).find()) {
                        LOG.debug("Line contains Helm Chart directive, file will not be analyzed.\n{}", (Object)line);
                        boolean bl = false;
                        return bl;
                    }
                    if (identifierCount != 4) continue;
                    hasExpectedIdentifier = true;
                }
            }
            catch (IOException e) {
                LOG.error("Unable to read file: {}.", (Object)inputFile.uri());
                LOG.error(e.getMessage());
            }
            if (hasExpectedIdentifier) {
                return true;
            }
            LOG.debug("File without Kubernetes identifier: {}", (Object)inputFile.uri());
            return false;
        }
    }
}

