/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.rules.RuleType;
import org.sonar.plugins.python.TextReportReader;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public abstract class ExternalIssuesSensor
implements Sensor {
    private static final int MAX_LOGGED_FILE_NAMES = 20;
    private static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;
    protected static final String PYLINT_LEGACY_KEY = "sonar.python.pylint.reportPath";

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(this::shouldExecute).onlyOnLanguage("py").name("Import of " + this.linterName() + " issues");
    }

    public void execute(SensorContext context) {
        HashSet<String> unresolvedInputFiles = new HashSet<String>();
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, this.reportPathKey());
        if (reportFiles.isEmpty() && context.config().hasKey(PYLINT_LEGACY_KEY)) {
            reportFiles = ExternalReportProvider.getReportFiles(context, PYLINT_LEGACY_KEY);
            this.logger().warn("The use of '{}' is deprecated. Please use the '{}' property instead.", (Object)PYLINT_LEGACY_KEY, (Object)"sonar.python.pylint.reportPaths");
        }
        reportFiles.forEach(report -> this.importExternalReport((File)report, context, (Set<String>)unresolvedInputFiles));
        this.logUnresolvedInputFiles(unresolvedInputFiles);
    }

    private void importExternalReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) {
        try {
            this.importReport(reportPath, context, unresolvedInputFiles);
        }
        catch (IOException | RuntimeException | ParseException e) {
            this.logFileCantBeRead(e, reportPath);
        }
    }

    private void logUnresolvedInputFiles(Set<String> unresolvedInputFiles) {
        if (unresolvedInputFiles.isEmpty()) {
            return;
        }
        Object fileList = unresolvedInputFiles.stream().sorted().limit(20L).collect(Collectors.joining(";"));
        if (unresolvedInputFiles.size() > 20) {
            fileList = (String)fileList + ";...";
        }
        this.logger().warn("Failed to resolve {} file path(s) in " + this.linterName() + " report. No issues imported related to file(s): {}", (Object)unresolvedInputFiles.size(), fileList);
    }

    private void logFileCantBeRead(Exception e, File reportPath) {
        this.logger().error("No issues information will be saved as the report file '{}' can't be read. {}: {}", new Object[]{reportPath, e.getClass().getSimpleName(), e.getMessage()});
    }

    protected void saveIssue(SensorContext context, TextReportReader.Issue issue, Set<String> unresolvedInputFiles, String linterKey) {
        InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(issue.filePath));
        if (inputFile == null) {
            unresolvedInputFiles.add(issue.filePath);
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        newExternalIssue.type(RuleType.CODE_SMELL).severity(Severity.MAJOR).remediationEffortMinutes(DEFAULT_CONSTANT_DEBT_MINUTES);
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile);
        if (issue.columnNumber != null && issue.columnNumber < inputFile.selectLine(issue.lineNumber.intValue()).end().lineOffset()) {
            primaryLocation.at(inputFile.newRange(issue.lineNumber.intValue(), issue.columnNumber.intValue(), issue.lineNumber.intValue(), issue.columnNumber + 1));
        } else {
            primaryLocation.at(inputFile.selectLine(issue.lineNumber.intValue()));
        }
        newExternalIssue.at(primaryLocation);
        newExternalIssue.engineId(linterKey).ruleId(issue.ruleKey);
        newExternalIssue.save();
    }

    protected abstract void importReport(File var1, SensorContext var2, Set<String> var3) throws IOException, ParseException;

    protected abstract boolean shouldExecute(Configuration var1);

    protected abstract String linterName();

    protected abstract String reportPathKey();

    protected abstract Logger logger();
}

