/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonInputFileContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolTableBuilder;

public class PythonVisitorContext
extends PythonInputFileContext {
    private final FileInput rootTree;
    private final RecognitionException parsingException;
    private List<PythonCheck.PreciseIssue> issues = new ArrayList<PythonCheck.PreciseIssue>();

    public PythonVisitorContext(FileInput rootTree, PythonFile pythonFile, @Nullable File workingDirectory, @Nullable String packageName) {
        super(pythonFile, workingDirectory, CacheContextImpl.dummyCache());
        this.rootTree = rootTree;
        this.parsingException = null;
        SymbolTableBuilder symbolTableBuilder = packageName != null ? new SymbolTableBuilder(packageName, pythonFile) : new SymbolTableBuilder(pythonFile);
        symbolTableBuilder.visitFileInput(rootTree);
    }

    public PythonVisitorContext(FileInput rootTree, PythonFile pythonFile, @Nullable File workingDirectory, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable, CacheContext cacheContext) {
        super(pythonFile, workingDirectory, cacheContext);
        this.rootTree = rootTree;
        this.parsingException = null;
        new SymbolTableBuilder(packageName, pythonFile, projectLevelSymbolTable).visitFileInput(rootTree);
    }

    public PythonVisitorContext(PythonFile pythonFile, RecognitionException parsingException) {
        super(pythonFile, null, CacheContextImpl.dummyCache());
        this.rootTree = null;
        this.parsingException = parsingException;
    }

    public FileInput rootTree() {
        return this.rootTree;
    }

    public RecognitionException parsingException() {
        return this.parsingException;
    }

    public void addIssue(PythonCheck.PreciseIssue issue) {
        this.issues.add(issue);
    }

    public List<PythonCheck.PreciseIssue> getIssues() {
        return this.issues;
    }
}

