/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;

@Beta
public class PythonQuickFix {
    private final String description;
    private final List<PythonTextEdit> textEdits;

    private PythonQuickFix(String description, List<PythonTextEdit> textEdits) {
        this.description = description;
        this.textEdits = textEdits;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PythonTextEdit> getTextEdits() {
        return this.textEdits;
    }

    public static Builder newQuickFix(String description) {
        return new Builder(description);
    }

    public static PythonQuickFix newQuickFix(String description, PythonTextEdit ... textEdits) {
        return PythonQuickFix.newQuickFix(description).addTextEdit(textEdits).build();
    }

    public static class Builder {
        private final String description;
        private final List<PythonTextEdit> textEdits = new ArrayList<PythonTextEdit>();

        private Builder(String description) {
            this.description = description;
        }

        public Builder addTextEdit(PythonTextEdit ... textEdits) {
            return this.addTextEdit(Arrays.asList(textEdits));
        }

        public Builder addTextEdit(List<PythonTextEdit> textEdits) {
            this.textEdits.addAll(textEdits);
            return this;
        }

        public PythonQuickFix build() {
            return new PythonQuickFix(this.description, this.textEdits);
        }
    }
}

