/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.coverage;

import com.ctc.wstx.exc.WstxEOFException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMInputCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.plugins.python.EmptyReportException;
import org.sonar.plugins.python.parser.StaxParser;

public class CoberturaParser {
    private static final Logger LOG = LoggerFactory.getLogger(CoberturaParser.class);
    private final Set<String> errors = new HashSet<String>();
    private int unresolvedFilenameCount;

    public void parseReport(File xmlFile, SensorContext context, Map<InputFile, NewCoverage> coverageData) throws XMLStreamException {
        LOG.info("Parsing report '{}'", (Object)xmlFile);
        this.unresolvedFilenameCount = 0;
        StaxParser parser = new StaxParser(rootCursor -> {
            File defaultBaseDirectory = context.fileSystem().baseDir();
            List<File> baseDirectories = Collections.singletonList(defaultBaseDirectory);
            try {
                rootCursor.advance();
            }
            catch (WstxEOFException eofExc) {
                LOG.debug("Unexpected end of file is encountered", (Throwable)eofExc);
                throw new EmptyReportException();
            }
            SMInputCursor cursor = rootCursor.childElementCursor();
            while (cursor.getNext() != null) {
                if ("sources".equals(cursor.getLocalName())) {
                    baseDirectories = this.extractBaseDirectories(cursor, defaultBaseDirectory);
                    continue;
                }
                if (!"packages".equals(cursor.getLocalName())) continue;
                this.collectFileMeasures(cursor.descendantElementCursor("class"), context, coverageData, baseDirectories);
            }
        });
        parser.parse(xmlFile);
        if (this.unresolvedFilenameCount > 1) {
            String message = String.format("Cannot resolve %d file paths, ignoring coverage measures for those files", this.unresolvedFilenameCount);
            LOG.error(message);
            this.errors.add(message);
        }
    }

    private List<File> extractBaseDirectories(SMInputCursor sources, File defaultBaseDirectory) throws XMLStreamException {
        ArrayList<File> baseDirectories = new ArrayList<File>();
        SMInputCursor source = sources.childElementCursor("source");
        while (source.getNext() != null) {
            String path = FilenameUtils.normalize(source.collectDescendantText());
            if (StringUtils.isBlank(path)) continue;
            File baseDirectory = new File(path);
            if (baseDirectory.isDirectory()) {
                baseDirectories.add(baseDirectory);
                continue;
            }
            String formattedMessage = String.format("Invalid directory path in 'source' element: %s", path);
            LOG.warn(formattedMessage);
            this.errors.add(formattedMessage);
        }
        if (baseDirectories.isEmpty()) {
            return Collections.singletonList(defaultBaseDirectory);
        }
        return baseDirectories;
    }

    private void collectFileMeasures(SMInputCursor classCursor, SensorContext context, Map<InputFile, NewCoverage> coverageData, List<File> baseDirectories) throws XMLStreamException {
        while (classCursor.getNext() != null) {
            String filename = FilenameUtils.normalize(classCursor.getAttrValue("filename"));
            InputFile inputFile = this.resolve(context, baseDirectories, filename);
            if (inputFile != null) {
                NewCoverage coverage = coverageData.computeIfAbsent(inputFile, f -> context.newCoverage().onFile(f));
                CoberturaParser.collectFileData(classCursor, coverage);
                continue;
            }
            classCursor.advance();
        }
    }

    @Nullable
    private InputFile resolve(SensorContext context, List<File> baseDirectories, String filename) {
        String absolutePath;
        File file = new File(filename);
        if (file.isAbsolute()) {
            if (!file.exists()) {
                this.logUnresolvedFile("Cannot resolve the file path '%s' of the coverage report, the file does not exist in all 'source'.", filename);
            }
            absolutePath = file.getAbsolutePath();
        } else {
            List fileList = baseDirectories.stream().map(base -> new File((File)base, filename)).filter(File::exists).collect(Collectors.toList());
            if (fileList.isEmpty()) {
                this.logUnresolvedFile("Cannot resolve the file path '%s' of the coverage report, the file does not exist in all 'source'.", filename);
                return null;
            }
            if (fileList.size() > 1) {
                this.logUnresolvedFile("Cannot resolve the file path '%s' of the coverage report, ambiguity, the file exists in several 'source'.", filename);
                return null;
            }
            absolutePath = ((File)fileList.get(0)).getAbsolutePath();
        }
        return context.fileSystem().inputFile(context.fileSystem().predicates().hasAbsolutePath(absolutePath));
    }

    private void logUnresolvedFile(String message, String filename) {
        ++this.unresolvedFilenameCount;
        if (this.unresolvedFilenameCount == 1) {
            String formattedMessage = String.format(message, filename);
            LOG.error(formattedMessage);
            this.errors.add(formattedMessage);
        }
    }

    private static void collectFileData(SMInputCursor classCursor, NewCoverage coverage) throws XMLStreamException {
        SMInputCursor line = classCursor.childElementCursor("lines").advance().childElementCursor("line");
        while (line.getNext() != null) {
            int lineId = Integer.parseInt(line.getAttrValue("number"));
            coverage.lineHits(lineId, Integer.parseInt(line.getAttrValue("hits")));
            String isBranch = line.getAttrValue("branch");
            String text = line.getAttrValue("condition-coverage");
            if (!StringUtils.equals(isBranch, "true") || !StringUtils.isNotBlank(text)) continue;
            String[] conditions = StringUtils.split(StringUtils.substringBetween(text, "(", ")"), "/");
            coverage.conditions(lineId, Integer.parseInt(conditions[1]), Integer.parseInt(conditions[0]));
        }
    }

    public Set<String> errors() {
        return this.errors;
    }
}

