/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.flake8;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.sonar.plugins.python.ExternalIssuesSensor;
import org.sonar.plugins.python.TextReportReader;

public class Flake8Sensor
extends ExternalIssuesSensor {
    private static final Logger LOG = LoggerFactory.getLogger(Flake8Sensor.class);
    public static final String LINTER_NAME = "Flake8";
    public static final String LINTER_KEY = "flake8";
    public static final String REPORT_PATH_KEY = "sonar.python.flake8.reportPaths";

    @Override
    protected void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) throws IOException {
        List<TextReportReader.Issue> issues = new TextReportReader(1).parse(reportPath, context.fileSystem());
        issues.forEach(i -> this.saveIssue(context, (TextReportReader.Issue)i, unresolvedInputFiles, LINTER_KEY));
    }

    @Override
    protected boolean shouldExecute(Configuration conf) {
        return conf.hasKey(REPORT_PATH_KEY);
    }

    @Override
    protected String linterName() {
        return LINTER_NAME;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected Logger logger() {
        return LOG;
    }
}

