/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.ruff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.rules.RuleType;
import org.sonar.plugins.python.ExternalIssuesSensor;
import org.sonar.plugins.python.ruff.RuffJsonReportReader;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class RuffSensor
extends ExternalIssuesSensor {
    private static final Logger LOG = LoggerFactory.getLogger(RuffSensor.class);
    public static final String LINTER_NAME = "Ruff";
    public static final String LINTER_KEY = "ruff";
    public static final String REPORT_PATH_KEY = "sonar.python.ruff.reportPaths";
    private static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;

    @Override
    protected boolean shouldExecute(Configuration conf) {
        return conf.hasKey(REPORT_PATH_KEY);
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String linterName() {
        return LINTER_NAME;
    }

    @Override
    protected Logger logger() {
        return LOG;
    }

    @Override
    protected void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) throws IOException, ParseException {
        FileInputStream in = new FileInputStream(reportPath);
        LOG.info("Importing {}", (Object)reportPath);
        RuffJsonReportReader.read(in, issue -> RuffSensor.saveIssue(context, issue, unresolvedInputFiles));
    }

    private static void saveIssue(SensorContext context, RuffJsonReportReader.Issue issue, Set<String> unresolvedInputFiles) {
        if (StringUtils.isEmpty(issue.ruleKey) || StringUtils.isEmpty(issue.filePath) || StringUtils.isEmpty(issue.message)) {
            LOG.debug("Missing information for ruleKey:'{}', filePath:'{}', message:'{}'", new Object[]{issue.ruleKey, issue.filePath, issue.message});
            return;
        }
        InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(issue.filePath));
        if (inputFile == null) {
            unresolvedInputFiles.add(issue.filePath);
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        newExternalIssue.type(RuleType.CODE_SMELL).severity(Severity.MAJOR).remediationEffortMinutes(DEFAULT_CONSTANT_DEBT_MINUTES);
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile);
        if (issue.startLocationRow != null) {
            if (RuffSensor.isValidEndLocation(issue, inputFile)) {
                primaryLocation.at(inputFile.newRange(issue.startLocationRow.intValue(), issue.startLocationCol.intValue(), issue.endLocationRow.intValue(), issue.endLocationCol.intValue()));
            } else {
                primaryLocation.at(inputFile.selectLine(issue.startLocationRow.intValue()));
            }
        }
        newExternalIssue.at(primaryLocation);
        newExternalIssue.engineId(LINTER_KEY);
        newExternalIssue.ruleId(issue.ruleKey).save();
    }

    private static boolean isValidEndLocation(RuffJsonReportReader.Issue issue, InputFile inputFile) {
        return issue.startLocationCol != null && issue.endLocationRow != null && issue.endLocationCol != null && RuffSensor.isColInBounds(issue.startLocationRow, issue.startLocationCol, inputFile) && (!issue.endLocationRow.equals(issue.startLocationRow) || !issue.endLocationCol.equals(issue.startLocationCol));
    }

    private static boolean isColInBounds(int lineNumber, int columnNumber, InputFile inputFile) {
        return columnNumber < inputFile.selectLine(lineNumber).end().lineOffset();
    }
}

