/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.xunit;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.parser.StaxParser;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;
import org.sonar.plugins.python.xunit.TestCase;
import org.sonar.plugins.python.xunit.TestResult;
import org.sonar.plugins.python.xunit.TestSuite;
import org.sonar.plugins.python.xunit.TestSuiteParser;

public class PythonXUnitSensor
extends PythonReportSensor {
    private static final Logger LOG = LoggerFactory.getLogger(PythonXUnitSensor.class);
    public static final String REPORT_PATH_KEY = "sonar.python.xunit.reportPath";
    public static final String DEFAULT_REPORT_PATH = "xunit-reports/xunit-result-*.xml";
    public static final String SKIP_DETAILS = "sonar.python.xunit.skipDetails";
    private final FileSystem fileSystem;

    public PythonXUnitSensor(Configuration conf, FileSystem fileSystem, AnalysisWarningsWrapper analysisWarnings) {
        super(conf, analysisWarnings, "XUnit");
        this.fileSystem = fileSystem;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    protected void processReports(SensorContext context, List<File> reports) throws XMLStreamException {
        if (this.conf.getBoolean(SKIP_DETAILS).orElse(Boolean.FALSE).booleanValue()) {
            PythonXUnitSensor.simpleMode(context, reports);
        } else {
            this.detailedMode(context, reports);
        }
    }

    private static void simpleMode(SensorContext context, List<File> reports) throws XMLStreamException {
        TestSuiteParser parserHandler = new TestSuiteParser();
        StaxParser parser = new StaxParser(parserHandler);
        for (File report : reports) {
            parser.parse(report);
        }
        TestResult total = new TestResult();
        parserHandler.getParsedReports().forEach(testSuite -> testSuite.getTestCases().forEach(total::addTestCase));
        if (total.getTests() > 0) {
            InputModule module = context.module();
            PythonXUnitSensor.saveMeasure(context, (InputComponent)module, (Metric<Integer>)CoreMetrics.TESTS, total.getExecutedTests());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)module, (Metric<Integer>)CoreMetrics.SKIPPED_TESTS, total.getSkipped());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)module, (Metric<Integer>)CoreMetrics.TEST_ERRORS, total.getErrors());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)module, (Metric<Integer>)CoreMetrics.TEST_FAILURES, total.getFailures());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)module, (Metric<Long>)CoreMetrics.TEST_EXECUTION_TIME, (long)total.getTime());
        }
    }

    private void detailedMode(SensorContext context, List<File> reports) throws XMLStreamException {
        for (File report : reports) {
            TestSuiteParser parserHandler = new TestSuiteParser();
            StaxParser parser = new StaxParser(parserHandler);
            parser.parse(report);
            LOG.info("Processing report '{}'", (Object)report);
            this.processReportDetailed(context, parserHandler.getParsedReports());
        }
    }

    private void processReportDetailed(SensorContext context, Collection<TestSuite> parsedReports) {
        Map<InputFile, TestResult> locatedResources = this.lookupResources(parsedReports);
        for (Map.Entry<InputFile, TestResult> entry : locatedResources.entrySet()) {
            InputFile inputFile = entry.getKey();
            TestResult fileTestResult = entry.getValue();
            LOG.debug("Saving test execution measures for '{}'", (Object)inputFile);
            PythonXUnitSensor.saveMeasure(context, (InputComponent)inputFile, (Metric<Integer>)CoreMetrics.SKIPPED_TESTS, fileTestResult.getSkipped());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)inputFile, (Metric<Integer>)CoreMetrics.TESTS, fileTestResult.getExecutedTests());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)inputFile, (Metric<Integer>)CoreMetrics.TEST_ERRORS, fileTestResult.getErrors());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)inputFile, (Metric<Integer>)CoreMetrics.TEST_FAILURES, fileTestResult.getFailures());
            PythonXUnitSensor.saveMeasure(context, (InputComponent)inputFile, (Metric<Long>)CoreMetrics.TEST_EXECUTION_TIME, (long)fileTestResult.getTime());
        }
    }

    @CheckForNull
    private InputFile findResource(TestCase testCase, String fileKey) {
        InputFile unitTestFile = null;
        if (testCase.getFile() != null) {
            unitTestFile = this.getSonarTestFile(new File(testCase.getFile()));
        }
        if (unitTestFile == null) {
            String testClassname = testCase.getTestClassname();
            String key = testClassname != null ? testClassname : fileKey;
            return this.findResourceUsingNoseTestsStrategy(key);
        }
        return unitTestFile;
    }

    private InputFile findResourceUsingNoseTestsStrategy(String fileKey) {
        String candidateKey2;
        String candidateKey = StringUtils.replace(fileKey, ".", "/") + ".py";
        InputFile unitTestFile = this.getSonarTestFile(new File(candidateKey));
        if (unitTestFile == null && !(candidateKey2 = StringUtils.replace(StringUtils.substringBeforeLast(fileKey, "."), ".", "/") + ".py").equals(candidateKey)) {
            unitTestFile = this.getSonarTestFile(new File(candidateKey2));
        }
        return unitTestFile;
    }

    private Map<InputFile, TestResult> lookupResources(Collection<TestSuite> testReports) {
        HashMap<InputFile, TestResult> testResultsByFile = new HashMap<InputFile, TestResult>();
        for (TestSuite testSuite : testReports) {
            testSuite.getTestCases().forEach(testCase -> {
                String testClassname = testCase.getTestClassname();
                LOG.debug("Trying to find a SonarQube resource for test case '{}'", (Object)testClassname);
                InputFile inputFile = this.findResource((TestCase)testCase, testSuite.getKey());
                if (inputFile != null) {
                    LOG.debug("The resource was found '{}'", (Object)inputFile);
                    testResultsByFile.computeIfAbsent(inputFile, k -> new TestResult()).addTestCase((TestCase)testCase);
                } else {
                    LOG.warn("The resource for '{}' is not found, drilling down to the details of this test won't be possible", (Object)testClassname);
                }
            });
        }
        return testResultsByFile;
    }

    @CheckForNull
    private InputFile getSonarTestFile(File file) {
        LOG.debug("Using the key '{}' to lookup the resource in SonarQube", (Object)file.getPath());
        FilePredicate predicate = file.isAbsolute() ? this.fileSystem.predicates().hasAbsolutePath(file.getAbsolutePath()) : this.fileSystem.predicates().hasRelativePath(file.getPath());
        return this.fileSystem.inputFile(predicate);
    }

    private static void saveMeasure(SensorContext context, InputComponent component, Metric<Integer> metric, int value) {
        context.newMeasure().on(component).forMetric(metric).withValue((Serializable)Integer.valueOf(value)).save();
    }

    private static void saveMeasure(SensorContext context, InputComponent component, Metric<Long> metric, long value) {
        context.newMeasure().on(component).forMetric(metric).withValue((Serializable)Long.valueOf(value)).save();
    }
}

