/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.ReprExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="BackticksUsage")
public class BackticksUsageCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.REPR, ctx -> {
            ReprExpression node = (ReprExpression)ctx.syntaxNode();
            PythonCheck.PreciseIssue issue = ctx.addIssue(node, "Use \"repr\" instead.");
            PythonTextEdit text1 = TextEditUtils.replace(node.openingBacktick(), "repr(");
            PythonTextEdit text2 = TextEditUtils.replace(node.closingBacktick(), ")");
            PythonQuickFix quickFix = PythonQuickFix.newQuickFix("Replace backtick with \"repr()\".").addTextEdit(text1).addTextEdit(text2).build();
            issue.addQuickFix(quickFix);
        });
    }
}

