/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.semantic.BuiltinSymbols;

@Rule(key="S3984")
public class ExceptionNotThrownCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Raise this exception or remove this useless statement.";
    public static final String QUICK_FIX_MESSAGE = "Raise this exception";
    private static final Set<String> BUILTIN_EXCEPTIONS_FQNS = Stream.of(BuiltinSymbols.EXCEPTIONS, BuiltinSymbols.EXCEPTIONS_PYTHON2).flatMap(Collection::stream).filter(n -> !"WindowsError".equals(n)).collect(Collectors.toSet());

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ExceptionNotThrownCheck.check(ExceptionNotThrownCheck::symbolFromInvocation));
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, ExceptionNotThrownCheck.check(ExceptionNotThrownCheck::symbolFromName));
    }

    private static Consumer<SubscriptionContext> check(Function<Tree, Symbol> extractClassSymbol) {
        return subscriptionContext -> {
            Tree parent;
            Tree t = subscriptionContext.syntaxNode();
            Symbol symb = (Symbol)extractClassSymbol.apply(t);
            if (symb != null && symb.is(Symbol.Kind.CLASS) && ExceptionNotThrownCheck.isThrowable((ClassSymbol)symb) && (parent = t.parent()).is(Tree.Kind.EXPRESSION_STMT)) {
                PythonCheck.PreciseIssue issue = subscriptionContext.addIssue(t, MESSAGE);
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(TextEditUtils.insertBefore(t, "raise ")).build();
                issue.addQuickFix(quickFix);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isThrowable(ClassSymbol cs) {
        if (!BUILTIN_EXCEPTIONS_FQNS.contains(cs.fullyQualifiedName())) {
            if (!cs.superClasses().stream().map(Symbol::fullyQualifiedName).anyMatch(BUILTIN_EXCEPTIONS_FQNS::contains)) return false;
        }
        if ("WindowsError".equals(cs.fullyQualifiedName())) return false;
        return true;
    }

    @Nullable
    private static Symbol symbolFromInvocation(Tree t) {
        return ((CallExpression)t).calleeSymbol();
    }

    @Nullable
    private static Symbol symbolFromName(Tree t) {
        return ((Name)t).symbol();
    }
}

