/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.types.InferredTypes;

@Rule(key="S6538")
public class MandatoryFunctionReturnTypeHintCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Add a return type hint to this function declaration.";
    public static final String CONSTRUCTOR_MESSAGE = "Annotate the return type of this constructor with `None`.";
    private static final List<String> SUPPORTED_TYPES = List.of("str", "NoneType", "bool", "complex", "float", "int");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (functionDef.returnTypeAnnotation() == null) {
                Name functionName = functionDef.name();
                FunctionDefImpl functionDefImpl = (FunctionDefImpl)functionDef;
                Optional.ofNullable(functionDefImpl.functionSymbol()).filter(functionSymbol -> "__init__".equals(functionName.name()) && functionSymbol.isInstanceMethod()).ifPresentOrElse(symbol -> MandatoryFunctionReturnTypeHintCheck.raiseIssueForConstructor(ctx, functionName, functionDef), () -> MandatoryFunctionReturnTypeHintCheck.raiseIssueForReturnType(ctx, functionName, functionDef));
            }
        });
    }

    private static void raiseIssueForConstructor(SubscriptionContext ctx, Name functionName, FunctionDef functionDef) {
        PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(functionName, CONSTRUCTOR_MESSAGE);
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix(CONSTRUCTOR_MESSAGE).addTextEdit(TextEditUtils.insertAfter(functionDef.rightPar(), " -> None")).build();
        preciseIssue.addQuickFix(quickFix);
    }

    private static void raiseIssueForReturnType(SubscriptionContext ctx, Name functionName, FunctionDef functionDef) {
        PythonCheck.PreciseIssue issue = ctx.addIssue(functionName, MESSAGE);
        ReturnStatementVisitor returnStatementVisitor = new ReturnStatementVisitor();
        functionDef.body().accept(returnStatementVisitor);
        if (!returnStatementVisitor.returnStatements.isEmpty()) {
            MandatoryFunctionReturnTypeHintCheck.addQuickFixForReturnType(issue, functionDef, returnStatementVisitor.returnStatements);
        } else if (returnStatementVisitor.yieldStatements.isEmpty()) {
            MandatoryFunctionReturnTypeHintCheck.addQuickFixForNoneType(issue, functionDef);
        }
    }

    private static void addQuickFixForNoneType(PythonCheck.PreciseIssue issue, FunctionDef functionDef) {
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix(MESSAGE).addTextEdit(TextEditUtils.insertAfter(functionDef.rightPar(), " -> None")).build();
        issue.addQuickFix(quickFix);
    }

    private static void addQuickFixForReturnType(PythonCheck.PreciseIssue issue, FunctionDef functionDef, List<ReturnStatement> statements) {
        String typeName;
        Set returnTypes = statements.stream().flatMap(stmts -> stmts.expressions().stream()).map(Expression::type).map(InferredTypes::typeName).filter(Objects::nonNull).collect(Collectors.toSet());
        if (returnTypes.size() == 1 && SUPPORTED_TYPES.contains(typeName = (String)returnTypes.stream().iterator().next())) {
            PythonQuickFix quickFix = PythonQuickFix.newQuickFix(MESSAGE).addTextEdit(TextEditUtils.insertAfter(functionDef.rightPar(), String.format(" -> %s", MandatoryFunctionReturnTypeHintCheck.fixTypeName(typeName)))).build();
            issue.addQuickFix(quickFix);
        }
    }

    private static String fixTypeName(String typeName) {
        return typeName.equals("NoneType") ? "None" : typeName;
    }

    private static class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private final List<ReturnStatement> returnStatements = new ArrayList<ReturnStatement>();
        private final List<YieldStatement> yieldStatements = new ArrayList<YieldStatement>();

        private ReturnStatementVisitor() {
        }

        @Override
        public void visitReturnStatement(ReturnStatement pyReturnStatementTree) {
            super.visitReturnStatement(pyReturnStatementTree);
            this.returnStatements.add(pyReturnStatementTree);
        }

        @Override
        public void visitYieldStatement(YieldStatement pyYieldStatementTree) {
            super.visitYieldStatement(pyYieldStatementTree);
            this.yieldStatements.add(pyYieldStatementTree);
        }
    }
}

