/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S1110")
public class UselessParenthesisCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1110";
    private static final String MESSAGE = "Remove those redundant parentheses.";
    public static final String QUICK_FIX_MESSAGE = "Remove the redundant parentheses";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.PARENTHESIZED, ctx -> {
            ParenthesizedExpression parenthesized = (ParenthesizedExpression)ctx.syntaxNode();
            Expression expression = parenthesized.expression();
            if (expression.is(Tree.Kind.PARENTHESIZED, Tree.Kind.TUPLE, Tree.Kind.GENERATOR_EXPR)) {
                PythonCheck.PreciseIssue issue = ctx.addIssue(parenthesized.leftParenthesis(), MESSAGE).secondary(parenthesized.rightParenthesis(), null);
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(TextEditUtils.remove(parenthesized.leftParenthesis()), TextEditUtils.remove(parenthesized.rightParenthesis())).build();
                issue.addQuickFix(quickFix);
            }
        });
    }
}

