/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6463")
public class UnrestrictedOutboundCommunicationsCheck
extends AbstractCdkResourceCheck {
    public static final String OMITTING_MESSAGE = "Omitting \"allow_all_outbound\" enables unrestricted outbound communications. Make sure it is safe here.";
    public static final String UNRESTRICTED_MESSAGE = "Make sure that allowing unrestricted outbound communications is safe here.";
    private static final String SECURITY_GROUP_FQN = "aws_cdk.aws_ec2.SecurityGroup";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqns(List.of(SECURITY_GROUP_FQN, "aws_cdk.aws_ec2.SecurityGroup.from_security_group_id"), (subscriptionContext, callExpression) -> CdkUtils.getArgument(subscriptionContext, callExpression, "allow_all_outbound").ifPresentOrElse(argument -> argument.addIssueIf(CdkPredicate.isTrue(), UNRESTRICTED_MESSAGE, new IssueLocation[0]), () -> UnrestrictedOutboundCommunicationsCheck.raiseIssue(subscriptionContext, callExpression)));
    }

    private static void raiseIssue(SubscriptionContext subscriptionContext, CallExpression callExpression) {
        Optional.ofNullable(callExpression.calleeSymbol()).map(Symbol::fullyQualifiedName).filter(fqn -> fqn.equals(SECURITY_GROUP_FQN)).ifPresent(s -> subscriptionContext.addIssue(callExpression.callee(), OMITTING_MESSAGE));
    }
}

