/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.django;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.checks.django.DjangoUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6554")
public class DjangoModelStrMethodCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Define a \"__str__\" method for this Django model.";
    private static final List<String> DJANGO_MODEL_FQN = List.of("django.db.models.Model");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            List<String> parentClassesFQN = TreeUtils.getParentClassesFQN(classDef);
            if (DJANGO_MODEL_FQN.equals(parentClassesFQN)) {
                if (DjangoModelStrMethodCheck.isAbstractModel(classDef)) {
                    return;
                }
                boolean hasStrMethod = DjangoModelStrMethodCheck.hasStrMethod(classDef);
                if (!hasStrMethod) {
                    ctx.addIssue(classDef.name(), MESSAGE);
                }
            }
        });
    }

    private static boolean isAbstractModel(ClassDef classDef) {
        return DjangoUtils.getMetaClass(classDef).flatMap(metaClass -> DjangoUtils.getFieldAssignment(metaClass, "abstract")).filter(assignmentStatement -> Expressions.isTruthy(assignmentStatement.assignedValue())).isPresent();
    }

    private static boolean hasStrMethod(ClassDef classDef) {
        String strMethodFqn = DjangoModelStrMethodCheck.getStrMethodFqn(classDef);
        return TreeUtils.topLevelFunctionDefs(classDef).stream().map(TreeUtils::getFunctionSymbolFromDef).filter(Objects::nonNull).map(Symbol::fullyQualifiedName).filter(Objects::nonNull).anyMatch(strMethodFqn::equals);
    }

    private static String getStrMethodFqn(ClassDef classDef) {
        String classFqn = Optional.of(classDef).map(TreeUtils::getClassSymbolFromDef).map(Symbol::fullyQualifiedName).orElse("");
        return classFqn + ".__str__";
    }
}

