/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.python.checks.hotspots.AbstractCookieFlagCheck;

@Rule(key="S2092")
public class SecureCookieCheck
extends AbstractCookieFlagCheck {
    private static Map<String, Integer> sensitiveArgumentByFQN = new HashMap<String, Integer>();

    @Override
    String flagName() {
        return "secure";
    }

    @Override
    String message() {
        return "Make sure creating this cookie without the \"secure\" flag is safe.";
    }

    @Override
    Map<String, Integer> sensitiveArgumentByFQN() {
        return sensitiveArgumentByFQN;
    }

    static {
        sensitiveArgumentByFQN.put("django.http.response.HttpResponseBase.set_cookie", 6);
        sensitiveArgumentByFQN.put("django.http.response.HttpResponseBase.set_signed_cookie", 7);
        sensitiveArgumentByFQN.put("flask.wrappers.Response.set_cookie", 6);
        sensitiveArgumentByFQN.put("werkzeug.wrappers.BaseResponse.set_cookie", 6);
        sensitiveArgumentByFQN.put("werkzeug.sansio.response.Response.set_cookie", 7);
        sensitiveArgumentByFQN = Collections.unmodifiableMap(sensitiveArgumentByFQN);
    }
}

