/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class IPynbCellDelimiterChannel
extends Channel<Lexer> {
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Matcher matcher = Pattern.compile("#SONAR_PYTHON_NOTEBOOK_CELL_DELIMITER").matcher("");
    private final Token.Builder tokenBuilder = Token.builder();
    private final LexerState lexerState;

    public IPynbCellDelimiterChannel(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        if (code.getColumnPosition() != 0) {
            return false;
        }
        if (code.popTo(this.matcher, this.tmpBuilder) > 0) {
            this.resetIndentationLevel(code, lexer);
            String value = this.tmpBuilder.toString();
            Token token = this.tokenBuilder.setType(PythonTokenType.IPYNB_CELL_DELIMITER).setValueAndOriginalValue(value).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build();
            lexer.addToken(token);
            this.tmpBuilder.delete(0, this.tmpBuilder.length());
            return true;
        }
        return false;
    }

    private void resetIndentationLevel(CodeReader code, Lexer lexer) {
        while (this.lexerState.indentationStack.peek() > 0) {
            this.lexerState.indentationStack.pop();
            lexer.addToken(Token.builder().setType(PythonTokenType.DEDENT).setValueAndOriginalValue("").setURI(lexer.getURI()).setLine(code.getLinePosition()).setColumn(0).build());
        }
    }
}

