/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.quickfix;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

public class TextEditUtils {
    private TextEditUtils() {
    }

    public static PythonTextEdit insertLineBefore(Tree tree, String textToInsert) {
        String lineOffset = TextEditUtils.offset(tree);
        textToInsert = (String)textToInsert + "\n";
        String textWithOffset = ((String)textToInsert).replace("\n", "\n" + lineOffset);
        return TextEditUtils.insertBefore(tree, textWithOffset);
    }

    public static PythonTextEdit insertLineAfter(Tree tree, Tree indentReference, String textToInsert) {
        String lineOffset = TextEditUtils.offset(indentReference);
        String textWithOffset = "\n" + lineOffset + textToInsert.replace("\n", "\n" + lineOffset);
        return TextEditUtils.insertAfter(tree, textWithOffset);
    }

    private static String offset(Tree referenceTree) {
        return " ".repeat(referenceTree.firstToken().column());
    }

    public static PythonTextEdit insertBefore(Tree tree, String textToInsert) {
        Token token = tree.firstToken();
        return TextEditUtils.insertAtPosition(token.line(), token.column(), textToInsert);
    }

    public static PythonTextEdit insertAfter(Tree tree, String textToInsert) {
        Token token = tree.firstToken();
        int lengthToken = token.value().length();
        return TextEditUtils.insertAtPosition(token.line(), token.column() + lengthToken, textToInsert);
    }

    public static PythonTextEdit insertAtPosition(int line, int column, String textToInsert) {
        return new PythonTextEdit(textToInsert, line, column, line, column);
    }

    public static PythonTextEdit replace(Tree toReplace, String replacementText) {
        return TextEditUtils.replaceRange(toReplace, toReplace, replacementText);
    }

    public static PythonTextEdit replaceRange(Tree start, Tree end, String replacementText) {
        Token first = start.firstToken();
        Token last = end.lastToken();
        return new PythonTextEdit(replacementText, first.line(), first.column(), last.line(), last.column() + last.value().length());
    }

    public static List<PythonTextEdit> shiftLeft(StatementList statementList) {
        int offset = statementList.firstToken().column() - statementList.parent().firstToken().column();
        return statementList.statements().stream().map(statement -> TextEditUtils.shiftLeft(statement, offset)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static List<PythonTextEdit> shiftLeft(Tree tree, int offset) {
        return TreeUtils.tokens(tree).stream().filter(token -> token.column() >= offset).map(Token::line).distinct().map(line -> TextEditUtils.removeRange(line, 0, line, offset)).collect(Collectors.toList());
    }

    public static PythonTextEdit removeRange(int startLine, int startColumn, int endLine, int endColumn) {
        return new PythonTextEdit("", startLine, startColumn, endLine, endColumn);
    }

    public static PythonTextEdit removeUntil(Tree start, Tree until) {
        return TextEditUtils.removeRange(start.firstToken().line(), start.firstToken().column(), until.firstToken().line(), until.firstToken().column());
    }

    public static PythonTextEdit removeStatement(Statement statement) {
        boolean hasNextSiblingOnLine;
        Tree next;
        Token firstTokenOfStmt = statement.firstToken();
        Token lastTokenOfStmt = TreeUtils.getTreeSeparatorOrLastToken(statement);
        List<Tree> siblings = statement.parent().children();
        int indexOfTree = siblings.indexOf(statement);
        Tree previous = indexOfTree > 0 ? siblings.get(indexOfTree - 1) : null;
        Tree tree = next = indexOfTree < siblings.size() - 1 ? siblings.get(indexOfTree + 1) : null;
        if (previous == null && next == null) {
            return TextEditUtils.replace(statement, "pass");
        }
        boolean hasPreviousSiblingOnLine = previous != null && firstTokenOfStmt.line() == TreeUtils.getTreeSeparatorOrLastToken(previous.lastToken()).line();
        boolean bl = hasNextSiblingOnLine = next != null && lastTokenOfStmt.line() == next.firstToken().line();
        if (hasNextSiblingOnLine) {
            Token firstNextToken = next.firstToken();
            return TextEditUtils.removeRange(firstTokenOfStmt.line(), firstTokenOfStmt.column(), firstNextToken.line(), firstNextToken.column());
        }
        if (hasPreviousSiblingOnLine) {
            Token lastPreviousToken = TreeUtils.getTreeSeparatorOrLastToken(previous);
            return TextEditUtils.removeRange(lastPreviousToken.line(), TextEditUtils.getEndColumn(lastPreviousToken), lastPreviousToken.line(), TextEditUtils.getEndColumn(lastTokenOfStmt) - 1);
        }
        return TextEditUtils.removeRange(firstTokenOfStmt.line(), 0, lastTokenOfStmt.line(), TextEditUtils.getEndColumn(lastTokenOfStmt));
    }

    private static int getEndColumn(Token token) {
        return token.column() + token.value().length();
    }

    public static PythonTextEdit remove(Tree toRemove) {
        return TextEditUtils.replace(toRemove, "");
    }

    public static List<PythonTextEdit> renameAllUsages(HasSymbol node, String newName) {
        Symbol symbol = node.symbol();
        List<Object> usages = symbol != null ? symbol.usages() : Collections.emptyList();
        LinkedList<PythonTextEdit> result = new LinkedList<PythonTextEdit>();
        for (Usage usage : usages) {
            PythonTextEdit text = TextEditUtils.replace(usage.tree().firstToken(), newName);
            result.add(text);
        }
        return result;
    }
}

