/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;

class APMJvmOptions {
    private static final Map<String, String> STATIC_CONFIG = Map.of("service_version", Version.CURRENT.toString(), "log_file", "_AGENT_HOME_/../../logs/apm.log", "instrument", "false");
    private static final Map<String, String> CONFIG_DEFAULTS = Map.of("service_name", "elasticsearch", "environment", "dev", "log_level", "error", "application_packages", "org.elasticsearch,org.apache.lucene", "metrics_interval", "120s", "breakdown_metrics", "false", "central_config", "false");
    private static final List<String> STATIC_AGENT_KEYS = List.of("api_key", "aws_lambda_handler", "breakdown_metrics", "classes_excluded_from_instrumentation", "cloud_provider", "data_flush_timeout", "disable_metrics", "disable_send", "enabled", "enable_public_api_annotation_inheritance", "environment", "global_labels", "hostname", "include_process_args", "log_ecs_formatter_allow_list", "log_ecs_reformatting_additional_fields", "log_ecs_reformatting_dir", "log_file", "log_file_size", "log_format_file", "log_format_sout", "max_queue_size", "metrics_interval", "plugins_dir", "profiling_inferred_spans_lib_directory", "secret_token", "service_name", "service_node_name", "service_version", "stress_monitoring_interval", "trace_methods_duration_threshold", "use_jaxrs_path_as_transaction_name", "verify_server_cert");

    APMJvmOptions() {
    }

    static List<String> apmJvmOptions(Settings settings, @Nullable SecureSettings secrets, Path tmpdir) throws UserException, IOException {
        String nodeName;
        Path agentJar = APMJvmOptions.findAgentJar();
        if (agentJar == null) {
            return List.of();
        }
        Map<String, String> propertiesMap = APMJvmOptions.extractApmSettings(settings);
        if (!propertiesMap.containsKey("server_url") && !propertiesMap.containsKey("server_urls")) {
            return List.of();
        }
        if (!propertiesMap.containsKey("service_node_name") && (nodeName = settings.get("node.name")) != null) {
            propertiesMap.put("service_node_name", nodeName);
        }
        if (secrets != null) {
            APMJvmOptions.extractSecureSettings(secrets, propertiesMap);
        }
        Map<String, String> dynamicSettings = APMJvmOptions.extractDynamicSettings(propertiesMap);
        Path tmpProperties = APMJvmOptions.writeApmProperties(tmpdir, propertiesMap);
        ArrayList<String> options = new ArrayList<String>();
        options.add(APMJvmOptions.agentCommandLineOption(agentJar, tmpProperties));
        dynamicSettings.forEach((key, value) -> options.add("-Delastic.apm." + key + "=" + value));
        return options;
    }

    static String agentCommandLineOption(Path agentJar, Path tmpPropertiesFile) {
        return "-javaagent:" + agentJar + "=c=" + tmpPropertiesFile;
    }

    private static void extractSecureSettings(SecureSettings secrets, Map<String, String> propertiesMap) {
        Set settingNames = secrets.getSettingNames();
        for (String key : List.of("api_key", "secret_token")) {
            if (!settingNames.contains("tracing.apm." + key)) continue;
            SecureString token = secrets.getString("tracing.apm." + key);
            try {
                propertiesMap.put(key, token.toString());
            }
            finally {
                if (token == null) continue;
                token.close();
            }
        }
    }

    private static Map<String, String> extractDynamicSettings(Map<String, String> propertiesMap) {
        HashMap<String, String> cliOptionsMap = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> propertiesIterator = propertiesMap.entrySet().iterator();
        while (propertiesIterator.hasNext()) {
            Map.Entry<String, String> entry = propertiesIterator.next();
            if (STATIC_AGENT_KEYS.contains(entry.getKey())) continue;
            propertiesIterator.remove();
            cliOptionsMap.put(entry.getKey(), entry.getValue());
        }
        return cliOptionsMap;
    }

    static Map<String, String> extractApmSettings(Settings settings) throws UserException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Settings agentSettings = settings.getByPrefix("tracing.apm.agent.");
        agentSettings.keySet().forEach(key -> propertiesMap.put((String)key, String.valueOf(agentSettings.get(key))));
        Settings globalLabelsSettings = settings.getByPrefix("tracing.apm.agent.global_labels.");
        StringJoiner globalLabels = new StringJoiner(",");
        for (String globalLabel : globalLabelsSettings.keySet()) {
            propertiesMap.remove("global_labels." + globalLabel);
            String globalLabelValue = globalLabelsSettings.get(globalLabel);
            if (Strings.isNullOrBlank((String)globalLabelValue)) continue;
            globalLabelValue = globalLabelValue.replaceAll("[,=]", "_");
            globalLabels.add(String.join((CharSequence)"=", globalLabel, globalLabelValue));
        }
        if (globalLabels.length() > 0) {
            propertiesMap.put("global_labels", globalLabels.toString());
        }
        for (String key2 : STATIC_CONFIG.keySet()) {
            if (!propertiesMap.containsKey(key2)) continue;
            throw new UserException(78, "Do not set a value for [tracing.apm.agent." + key2 + "], as this is configured automatically by Elasticsearch");
        }
        CONFIG_DEFAULTS.forEach(propertiesMap::putIfAbsent);
        propertiesMap.putAll(STATIC_CONFIG);
        return propertiesMap;
    }

    static Path createTemporaryPropertiesFile(Path tmpdir) throws IOException {
        return Files.createTempFile(tmpdir, ".elstcapm.", ".tmp", new FileAttribute[0]);
    }

    private static Path writeApmProperties(Path tmpdir, Map<String, String> propertiesMap) throws IOException {
        Properties p = new Properties();
        p.putAll(propertiesMap);
        Path tmpFile = APMJvmOptions.createTemporaryPropertiesFile(tmpdir);
        try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
            p.store(os, " Automatically generated by Elasticsearch, do not edit!");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.deleteIfExists(tmpFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "elasticsearch[apmagent-cleanup]"));
        return tmpFile;
    }

    @Nullable
    private static Path findAgentJar() throws IOException, UserException {
        return APMJvmOptions.findAgentJar(System.getProperty("user.dir"));
    }

    static Path findAgentJar(String installDir) throws IOException, UserException {
        Path apmModule = Path.of(installDir, new String[0]).resolve("modules").resolve("apm");
        if (Files.notExists(apmModule, new LinkOption[0])) {
            if (Build.CURRENT.isProductionRelease()) {
                throw new UserException(70, "Expected to find [apm] module in [" + apmModule + "]! Installation is corrupt");
            }
            return null;
        }
        try (Stream<Path> apmStream = Files.list(apmModule);){
            List<Path> paths = apmStream.filter(path -> path.getFileName().toString().matches("elastic-apm-agent-\\d+\\.\\d+\\.\\d+\\.jar")).toList();
            if (paths.size() > 1) {
                throw new UserException(70, "Found multiple [elastic-apm-agent] jars under [" + apmModule + "]! Installation is corrupt.");
            }
            if (paths.isEmpty()) {
                throw new UserException(70, "Found no [elastic-apm-agent] jar under [" + apmModule + "]! Installation is corrupt.");
            }
            Path path2 = paths.get(0);
            return path2;
        }
    }
}

