/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.server.cli.ProcessUtil;

class ErrorPumpThread
extends Thread {
    private final BufferedReader reader;
    private final PrintWriter writer;
    private final CountDownLatch readyOrDead = new CountDownLatch(1);
    private volatile boolean ready;
    private volatile IOException ioFailure;

    ErrorPumpThread(PrintWriter errOutput, InputStream errInput) {
        super("server-cli[stderr_pump]");
        this.reader = new BufferedReader(new InputStreamReader(errInput, StandardCharsets.UTF_8));
        this.writer = errOutput;
    }

    String waitUntilReady() throws IOException {
        ProcessUtil.nonInterruptibleVoid(this.readyOrDead::await);
        if (this.ioFailure != null) {
            throw this.ioFailure;
        }
        return null;
    }

    void drain() {
        ProcessUtil.nonInterruptibleVoid(this::join);
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) == '\u0018') {
                    this.ready = true;
                    this.readyOrDead.countDown();
                    continue;
                }
                this.writer.println(line);
            }
        }
        catch (IOException e) {
            this.ioFailure = e;
        }
        finally {
            this.writer.flush();
            this.readyOrDead.countDown();
        }
    }
}

