/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.DSSPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.OpenSSHCertificateDecoder;
import org.apache.sshd.common.config.keys.impl.RSAPublicKeyDecoder;
import org.apache.sshd.common.config.keys.impl.SkECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.SkED25519PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.u2f.SkED25519PublicKey;
import org.apache.sshd.common.config.keys.u2f.SkEcdsaPublicKey;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.digest.DigestUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class KeyUtils {
    public static final String RSA_ALGORITHM = "RSA";
    public static final BigInteger DEFAULT_RSA_PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    public static final String DSS_ALGORITHM = "DSA";
    public static final String EC_ALGORITHM = "EC";
    public static final Set<PosixFilePermission> STRICTLY_PROHIBITED_FILE_PERMISSION = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_READ, new PosixFilePermission[]{PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE}));
    public static final String KEY_FINGERPRINT_FACTORY_PROP = "org.apache.sshd.keyFingerprintFactory";
    public static final DigestFactory DEFAULT_FINGERPRINT_DIGEST_FACTORY = BuiltinDigests.sha256;
    public static final String RSA_SHA256_KEY_TYPE_ALIAS = "rsa-sha2-256";
    public static final String RSA_SHA512_KEY_TYPE_ALIAS = "rsa-sha2-512";
    public static final String RSA_SHA256_CERT_TYPE_ALIAS = "rsa-sha2-256-cert-v01@openssh.com";
    public static final String RSA_SHA512_CERT_TYPE_ALIAS = "rsa-sha2-512-cert-v01@openssh.com";
    private static final AtomicReference<DigestFactory> DEFAULT_DIGEST_HOLDER = new AtomicReference();
    private static final Map<String, PublicKeyEntryDecoder<?, ?>> BY_KEY_TYPE_DECODERS_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final Map<Class<?>, PublicKeyEntryDecoder<?, ?>> BY_KEY_CLASS_DECODERS_MAP = new LinkedHashMap();
    private static final Map<String, String> KEY_TYPE_ALIASES = ((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)MapEntryUtils.NavigableMapBuilder.builder(String.CASE_INSENSITIVE_ORDER).put("rsa-sha2-256", "ssh-rsa")).put("rsa-sha2-512", "ssh-rsa")).put("rsa-sha2-256-cert-v01@openssh.com", "ssh-rsa-cert-v01@openssh.com")).put("rsa-sha2-512-cert-v01@openssh.com", "ssh-rsa-cert-v01@openssh.com")).build();
    private static final Map<String, String> SIGNATURE_ALGORITHM_MAP = ((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)MapEntryUtils.MapBuilder.builder().put("rsa-sha2-256-cert-v01@openssh.com", "rsa-sha2-256")).put("rsa-sha2-512-cert-v01@openssh.com", "rsa-sha2-512")).put("ssh-rsa-cert-v01@openssh.com", "ssh-rsa")).put("ssh-dss-cert-v01@openssh.com", "ssh-dss")).put("ssh-ed25519-cert-v01@openssh.com", "ssh-ed25519")).put("ecdsa-sha2-nistp256-cert-v01@openssh.com", KeyPairProvider.ECDSA_SHA2_NISTP256)).put("ecdsa-sha2-nistp384-cert-v01@openssh.com", KeyPairProvider.ECDSA_SHA2_NISTP384)).put("ecdsa-sha2-nistp521-cert-v01@openssh.com", KeyPairProvider.ECDSA_SHA2_NISTP521)).build();

    private KeyUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static AbstractMap.SimpleImmutableEntry<String, Object> validateStrictKeyFilePermissions(Path path, LinkOption ... options) throws IOException {
        String parentOwner;
        String owner;
        if (path == null || !Files.exists(path, options)) {
            return null;
        }
        Set<PosixFilePermission> perms = IoUtils.getPermissions(path, options);
        if (GenericUtils.isEmpty(perms)) {
            return null;
        }
        if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            PosixFilePermission p = PosixFilePermission.OTHERS_EXECUTE;
            return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Permissions violation (%s)", new Object[]{p}), p);
        }
        if (OsUtils.isUNIX()) {
            Path parent;
            PosixFilePermission p = IoUtils.validateExcludedPermissions(perms, STRICTLY_PROHIBITED_FILE_PERMISSION);
            if (p != null) {
                return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Permissions violation (%s)", new Object[]{p}), p);
            }
            if (Files.isRegularFile(path, options) && (p = IoUtils.validateExcludedPermissions(IoUtils.getPermissions(parent = path.getParent(), options), STRICTLY_PROHIBITED_FILE_PERMISSION)) != null) {
                return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Parent permissions violation (%s)", new Object[]{p}), p);
            }
        }
        if (GenericUtils.isEmpty(owner = IoUtils.getFileOwner(path, options))) {
            return null;
        }
        String current = OsUtils.getCurrentUser();
        HashSet<String> expected = new HashSet<String>();
        expected.add(current);
        if (OsUtils.isUNIX()) {
            expected.add("root");
        }
        if (!expected.contains(owner)) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>(String.format("Owner violation (%s)", owner), owner);
        }
        if (OsUtils.isUNIX() && Files.isRegularFile(path, options) && !GenericUtils.isEmpty(parentOwner = IoUtils.getFileOwner(path.getParent(), options)) && !expected.contains(parentOwner)) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>(String.format("Parent owner violation (%s)", parentOwner), parentOwner);
        }
        return null;
    }

    public static PublicKey loadPublicKey(Path path) throws IOException, GeneralSecurityException {
        List<AuthorizedKeyEntry> keys2 = AuthorizedKeyEntry.readAuthorizedKeys(Objects.requireNonNull(path), new OpenOption[0]);
        if (GenericUtils.isEmpty(keys2)) {
            return null;
        }
        if (keys2.size() > 1) {
            throw new InvalidKeySpecException("Public key file contains multiple entries: " + path);
        }
        return keys2.get(0).resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
    }

    public static KeyPair generateKeyPair(String keyType, int keySize) throws GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + keyType);
        }
        return decoder.generateKeyPair(keySize);
    }

    public static KeyPair cloneKeyPair(String keyType, KeyPair kp) throws GeneralSecurityException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(keyType);
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + keyType);
        }
        return decoder.cloneKeyPair(kp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPublicKeyEntryDecoder(PublicKeyEntryDecoder<?, ?> decoder) {
        Objects.requireNonNull(decoder, "No decoder specified");
        Class pubType = Objects.requireNonNull(decoder.getPublicKeyType(), "No public key type declared");
        Class prvType = Objects.requireNonNull(decoder.getPrivateKeyType(), "No private key type declared");
        Map<Class<?>, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_CLASS_DECODERS_MAP;
        synchronized (map) {
            BY_KEY_CLASS_DECODERS_MAP.put(pubType, decoder);
            BY_KEY_CLASS_DECODERS_MAP.put(prvType, decoder);
        }
        KeyUtils.registerPublicKeyEntryDecoderKeyTypes(decoder);
    }

    public static void registerPublicKeyEntryDecoderKeyTypes(PublicKeyEntryDecoder<?, ?> decoder) {
        Objects.requireNonNull(decoder, "No decoder specified");
        NavigableSet<String> names = ValidateUtils.checkNotNullAndNotEmpty(decoder.getSupportedKeyTypes(), "No supported key types", new Object[0]);
        for (String n : names) {
            PublicKeyEntryDecoder<?, ?> prev = KeyUtils.registerPublicKeyEntryDecoderForKeyType(n, decoder);
            if (prev == null) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder<?, ?> registerPublicKeyEntryDecoderForKeyType(String keyType, PublicKeyEntryDecoder<?, ?> decoder) {
        keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type specified");
        Objects.requireNonNull(decoder, "No decoder specified");
        Map<String, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return BY_KEY_TYPE_DECODERS_MAP.put(keyType, decoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<String> unregisterPublicKeyEntryDecoder(PublicKeyEntryDecoder<?, ?> decoder) {
        Objects.requireNonNull(decoder, "No decoder specified");
        Class pubType = Objects.requireNonNull(decoder.getPublicKeyType(), "No public key type declared");
        Class prvType = Objects.requireNonNull(decoder.getPrivateKeyType(), "No private key type declared");
        Map<Class<?>, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_CLASS_DECODERS_MAP;
        synchronized (map) {
            BY_KEY_CLASS_DECODERS_MAP.remove(pubType);
            BY_KEY_CLASS_DECODERS_MAP.remove(prvType);
        }
        return KeyUtils.unregisterPublicKeyEntryDecoderKeyTypes(decoder);
    }

    public static NavigableSet<String> unregisterPublicKeyEntryDecoderKeyTypes(PublicKeyEntryDecoder<?, ?> decoder) {
        Objects.requireNonNull(decoder, "No decoder specified");
        NavigableSet<String> names = ValidateUtils.checkNotNullAndNotEmpty(decoder.getSupportedKeyTypes(), "No supported key types", new Object[0]);
        NavigableSet<String> removed = Collections.emptyNavigableSet();
        for (String n : names) {
            PublicKeyEntryDecoder<?, ?> prev = KeyUtils.unregisterPublicKeyEntryDecoderForKeyType(n);
            if (prev == null) continue;
            if (removed.isEmpty()) {
                removed = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            if (removed.add(n)) continue;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder<?, ?> unregisterPublicKeyEntryDecoderForKeyType(String keyType) {
        keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type specified");
        Map<String, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return BY_KEY_TYPE_DECODERS_MAP.remove(keyType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(String keyType) {
        if (GenericUtils.isEmpty(keyType)) {
            return null;
        }
        Map<String, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return BY_KEY_TYPE_DECODERS_MAP.get(keyType);
        }
    }

    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(KeyPair kp) {
        PublicKeyEntryDecoder<?, ?> d2;
        if (kp == null) {
            return null;
        }
        PublicKeyEntryDecoder<?, ?> d1 = KeyUtils.getPublicKeyEntryDecoder(kp.getPublic());
        if (d1 == (d2 = KeyUtils.getPublicKeyEntryDecoder(kp.getPrivate()))) {
            return d1;
        }
        return null;
    }

    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(Key key) {
        if (key == null) {
            return null;
        }
        return KeyUtils.getPublicKeyEntryDecoder(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder<?, ?> getPublicKeyEntryDecoder(Class<?> keyType) {
        if (keyType == null || !Key.class.isAssignableFrom(keyType)) {
            return null;
        }
        Map<String, PublicKeyEntryDecoder<?, ?>> map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            PublicKeyEntryDecoder<?, ?> decoder = BY_KEY_CLASS_DECODERS_MAP.get(keyType);
            if (decoder != null) {
                return decoder;
            }
            for (PublicKeyEntryDecoder<?, ?> dec : BY_KEY_CLASS_DECODERS_MAP.values()) {
                Class pubType = dec.getPublicKeyType();
                Class prvType = dec.getPrivateKeyType();
                if (!pubType.isAssignableFrom(keyType) && !prvType.isAssignableFrom(keyType)) continue;
                return dec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigestFactory getDefaultFingerPrintFactory() {
        DigestFactory factory2 = null;
        AtomicReference<DigestFactory> atomicReference = DEFAULT_DIGEST_HOLDER;
        synchronized (atomicReference) {
            factory2 = DEFAULT_DIGEST_HOLDER.get();
            if (factory2 != null) {
                return factory2;
            }
            String propVal = System.getProperty(KEY_FINGERPRINT_FACTORY_PROP);
            factory2 = GenericUtils.isEmpty(propVal) ? DEFAULT_FINGERPRINT_DIGEST_FACTORY : (DigestFactory)ValidateUtils.checkNotNull(BuiltinDigests.fromFactoryName(propVal), "Unknown digest factory: %s", (Object)propVal);
            ValidateUtils.checkTrue(factory2.isSupported(), "Selected fingerprint digest not supported: %s", (Object)factory2.getName());
            DEFAULT_DIGEST_HOLDER.set(factory2);
        }
        return factory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultFingerPrintFactory(DigestFactory f) {
        AtomicReference<DigestFactory> atomicReference = DEFAULT_DIGEST_HOLDER;
        synchronized (atomicReference) {
            DEFAULT_DIGEST_HOLDER.set(Objects.requireNonNull(f, "No digest factory"));
        }
    }

    public static String getFingerPrint(PublicKey key) {
        return KeyUtils.getFingerPrint((Factory<? extends Digest>)KeyUtils.getDefaultFingerPrintFactory(), key);
    }

    public static String getFingerPrint(String password) {
        return KeyUtils.getFingerPrint(password, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(String password, Charset charset) {
        return KeyUtils.getFingerPrint(KeyUtils.getDefaultFingerPrintFactory(), password, charset);
    }

    public static String getFingerPrint(Factory<? extends Digest> f, PublicKey key) {
        return key == null ? null : KeyUtils.getFingerPrint(Objects.requireNonNull(f, "No digest factory").create(), key);
    }

    public static String getFingerPrint(Digest d, PublicKey key) {
        if (key == null) {
            return null;
        }
        try {
            ByteArrayBuffer buffer = new ByteArrayBuffer();
            buffer.putRawPublicKey(key);
            return DigestUtils.getFingerPrint(d, ((Buffer)buffer).array(), 0, ((Buffer)buffer).wpos());
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public static byte[] getRawFingerprint(PublicKey key) throws Exception {
        return KeyUtils.getRawFingerprint(KeyUtils.getDefaultFingerPrintFactory(), key);
    }

    public static byte[] getRawFingerprint(Factory<? extends Digest> f, PublicKey key) throws Exception {
        return key == null ? null : KeyUtils.getRawFingerprint(Objects.requireNonNull(f, "No digest factory").create(), key);
    }

    public static byte[] getRawFingerprint(Digest d, PublicKey key) throws Exception {
        if (key == null) {
            return null;
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(key);
        return DigestUtils.getRawFingerprint(d, ((Buffer)buffer).array(), 0, ((Buffer)buffer).wpos());
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s) {
        return KeyUtils.getFingerPrint(f, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s, Charset charset) {
        return KeyUtils.getFingerPrint(f.create(), s, charset);
    }

    public static String getFingerPrint(Digest d, String s) {
        return KeyUtils.getFingerPrint(d, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Digest d, String s, Charset charset) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        try {
            return DigestUtils.getFingerPrint(d, s, charset);
        }
        catch (Exception e) {
            return e.getClass().getSimpleName();
        }
    }

    public static AbstractMap.SimpleImmutableEntry<Boolean, String> checkFingerPrint(String expected, PublicKey key) {
        return KeyUtils.checkFingerPrint(expected, KeyUtils.getDefaultFingerPrintFactory(), key);
    }

    public static AbstractMap.SimpleImmutableEntry<Boolean, String> checkFingerPrint(String expected, Factory<? extends Digest> f, PublicKey key) {
        return KeyUtils.checkFingerPrint(expected, Objects.requireNonNull(f, "No digest factory").create(), key);
    }

    public static AbstractMap.SimpleImmutableEntry<Boolean, String> checkFingerPrint(String expected, Digest d, PublicKey key) {
        BuiltinDigests expectedFactory;
        if (key == null) {
            return null;
        }
        if (GenericUtils.isEmpty(expected)) {
            return new AbstractMap.SimpleImmutableEntry<Boolean, String>(false, KeyUtils.getFingerPrint(d, key));
        }
        int pos = expected.indexOf(58);
        if (pos < 0 || pos >= expected.length() - 1) {
            return new AbstractMap.SimpleImmutableEntry<Boolean, String>(false, KeyUtils.getFingerPrint(d, key));
        }
        String name = expected.substring(0, pos);
        String value = expected.substring(pos + 1);
        if (name.length() > 2) {
            expectedFactory = BuiltinDigests.fromFactoryName(name);
            if (expectedFactory == null) {
                return new AbstractMap.SimpleImmutableEntry<Boolean, String>(false, KeyUtils.getFingerPrint(d, key));
            }
            expected = name.toUpperCase() + ":" + value;
        } else {
            expectedFactory = BuiltinDigests.md5;
            expected = expectedFactory.getName().toUpperCase() + ":" + expected;
        }
        String fingerprint = KeyUtils.getFingerPrint((Factory<? extends Digest>)expectedFactory, key);
        boolean matches = BuiltinDigests.md5.getName().equals(expectedFactory.getName()) ? expected.equalsIgnoreCase(fingerprint) : expected.equals(fingerprint);
        return new AbstractMap.SimpleImmutableEntry<Boolean, String>(matches, fingerprint);
    }

    public static String getKeyType(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        PrivateKey key = kp.getPrivate();
        if (key != null) {
            return KeyUtils.getKeyType(key);
        }
        return KeyUtils.getKeyType(kp.getPublic());
    }

    public static String getKeyType(Key key) {
        if (key == null) {
            return null;
        }
        if (key instanceof DSAKey) {
            return "ssh-dss";
        }
        if (key instanceof RSAKey) {
            return "ssh-rsa";
        }
        if (key instanceof ECKey) {
            ECKey ecKey = (ECKey)((Object)key);
            ECParameterSpec ecSpec = ecKey.getParams();
            ECCurves curve = ECCurves.fromCurveParameters(ecSpec);
            if (curve == null) {
                return null;
            }
            return curve.getKeyType();
        }
        if (key instanceof SkEcdsaPublicKey) {
            return "sk-ecdsa-sha2-nistp256@openssh.com";
        }
        if ("EdDSA".equalsIgnoreCase(key.getAlgorithm())) {
            return "ssh-ed25519";
        }
        if (key instanceof SkED25519PublicKey) {
            return "sk-ssh-ed25519@openssh.com";
        }
        if (key instanceof OpenSshCertificate) {
            return ((OpenSshCertificate)key).getKeyType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllEquivalentKeyTypes(String keyType) {
        if (GenericUtils.isEmpty(keyType)) {
            return Collections.emptyList();
        }
        String canonicalName = KeyUtils.getCanonicalKeyType(keyType);
        ArrayList<String> equivalents = new ArrayList<String>();
        equivalents.add(canonicalName);
        Map<String, String> map = KEY_TYPE_ALIASES;
        synchronized (map) {
            for (Map.Entry<String, String> ae : KEY_TYPE_ALIASES.entrySet()) {
                String alias = ae.getKey();
                String name = ae.getValue();
                if (!canonicalName.equalsIgnoreCase(name)) continue;
                equivalents.add(alias);
            }
        }
        return equivalents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCanonicalKeyType(String keyType) {
        String canonicalName;
        if (GenericUtils.isEmpty(keyType)) {
            return keyType;
        }
        Map<String, String> map = KEY_TYPE_ALIASES;
        synchronized (map) {
            canonicalName = KEY_TYPE_ALIASES.get(keyType);
        }
        if (GenericUtils.isEmpty(canonicalName)) {
            return keyType;
        }
        return canonicalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<String> getRegisteredKeyTypeAliases() {
        Map<String, String> map = KEY_TYPE_ALIASES;
        synchronized (map) {
            return KEY_TYPE_ALIASES.isEmpty() ? Collections.emptyNavigableSet() : GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, KEY_TYPE_ALIASES.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> registerCanonicalKeyTypes(String keyType, Collection<String> aliases) {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type value");
        ValidateUtils.checkNotNullAndNotEmpty(aliases, "No aliases provided", new Object[0]);
        List<String> replaced = Collections.emptyList();
        Map<String, String> map = KEY_TYPE_ALIASES;
        synchronized (map) {
            for (String a : aliases) {
                ValidateUtils.checkNotNullAndNotEmpty(a, "Null/empty alias registration for %s", (Object)keyType);
                String prev = KEY_TYPE_ALIASES.put(a, keyType);
                if (GenericUtils.isEmpty(prev)) continue;
                if (replaced.isEmpty()) {
                    replaced = new ArrayList<String>();
                }
                replaced.add(prev);
            }
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unregisterCanonicalKeyTypeAlias(String alias) {
        if (GenericUtils.isEmpty(alias)) {
            return alias;
        }
        Map<String, String> map = KEY_TYPE_ALIASES;
        synchronized (map) {
            return KEY_TYPE_ALIASES.remove(alias);
        }
    }

    public static int getKeySize(Key key) {
        if (key == null) {
            return -1;
        }
        if (key instanceof RSAKey) {
            BigInteger n = ((RSAKey)((Object)key)).getModulus();
            return n.bitLength();
        }
        if (key instanceof DSAKey) {
            DSAParams params = ((DSAKey)((Object)key)).getParams();
            BigInteger p = params.getP();
            return p.bitLength();
        }
        if (key instanceof ECKey) {
            ECParameterSpec ecSpec = ((ECKey)((Object)key)).getParams();
            ECCurves curve = ECCurves.fromCurveParameters(ecSpec);
            if (curve != null) {
                return curve.getKeySize();
            }
        } else if ("EdDSA".equalsIgnoreCase(key.getAlgorithm())) {
            return SecurityUtils.getEDDSAKeySize(key);
        }
        return -1;
    }

    public static PublicKey findMatchingKey(PublicKey key, PublicKey ... keySet) {
        if (key == null || GenericUtils.isEmpty(keySet)) {
            return null;
        }
        return KeyUtils.findMatchingKey(key, Arrays.asList(keySet));
    }

    public static PublicKey findMatchingKey(PublicKey key, Collection<? extends PublicKey> keySet) {
        if (key == null || GenericUtils.isEmpty(keySet)) {
            return null;
        }
        for (PublicKey publicKey : keySet) {
            if (!KeyUtils.compareKeys(key, publicKey)) continue;
            return publicKey;
        }
        return null;
    }

    public static boolean compareKeyPairs(KeyPair k1, KeyPair k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return KeyUtils.compareKeys(k1.getPublic(), k2.getPublic()) && KeyUtils.compareKeys(k1.getPrivate(), k2.getPrivate());
    }

    public static boolean compareKeys(PublicKey k1, PublicKey k2) {
        if (k1 instanceof RSAPublicKey && k2 instanceof RSAPublicKey) {
            return KeyUtils.compareRSAKeys((RSAPublicKey)RSAPublicKey.class.cast(k1), (RSAPublicKey)RSAPublicKey.class.cast(k2));
        }
        if (k1 instanceof DSAPublicKey && k2 instanceof DSAPublicKey) {
            return KeyUtils.compareDSAKeys((DSAPublicKey)DSAPublicKey.class.cast(k1), (DSAPublicKey)DSAPublicKey.class.cast(k2));
        }
        if (k1 instanceof ECPublicKey && k2 instanceof ECPublicKey) {
            return KeyUtils.compareECKeys((ECPublicKey)ECPublicKey.class.cast(k1), (ECPublicKey)ECPublicKey.class.cast(k2));
        }
        if (k1 instanceof SkEcdsaPublicKey && k2 instanceof SkEcdsaPublicKey) {
            return KeyUtils.compareSkEcdsaKeys((SkEcdsaPublicKey)SkEcdsaPublicKey.class.cast(k1), (SkEcdsaPublicKey)SkEcdsaPublicKey.class.cast(k2));
        }
        if (k1 != null && "EdDSA".equalsIgnoreCase(k1.getAlgorithm()) && k2 != null && "EdDSA".equalsIgnoreCase(k2.getAlgorithm())) {
            return SecurityUtils.compareEDDSAPPublicKeys(k1, k2);
        }
        if (k1 instanceof SkED25519PublicKey && k2 instanceof SkED25519PublicKey) {
            return KeyUtils.compareSkEd25519Keys((SkED25519PublicKey)SkED25519PublicKey.class.cast(k1), (SkED25519PublicKey)SkED25519PublicKey.class.cast(k2));
        }
        if (k1 instanceof OpenSshCertificate && k2 instanceof OpenSshCertificate) {
            return KeyUtils.compareOpenSSHCertificateKeys((OpenSshCertificate)OpenSshCertificate.class.cast(k1), (OpenSshCertificate)OpenSshCertificate.class.cast(k2));
        }
        return false;
    }

    public static PublicKey recoverPublicKey(PrivateKey key) throws GeneralSecurityException {
        if (key instanceof RSAPrivateKey) {
            return KeyUtils.recoverRSAPublicKey((RSAPrivateKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return KeyUtils.recoverDSAPublicKey((DSAPrivateKey)key);
        }
        if (key != null && "EdDSA".equalsIgnoreCase(key.getAlgorithm())) {
            return SecurityUtils.recoverEDDSAPublicKey(key);
        }
        return null;
    }

    public static boolean compareKeys(PrivateKey k1, PrivateKey k2) {
        if (k1 instanceof RSAPrivateKey && k2 instanceof RSAPrivateKey) {
            return KeyUtils.compareRSAKeys((RSAPrivateKey)RSAPrivateKey.class.cast(k1), (RSAPrivateKey)RSAPrivateKey.class.cast(k2));
        }
        if (k1 instanceof DSAPrivateKey && k2 instanceof DSAPrivateKey) {
            return KeyUtils.compareDSAKeys((DSAPrivateKey)DSAPrivateKey.class.cast(k1), (DSAPrivateKey)DSAPrivateKey.class.cast(k2));
        }
        if (k1 instanceof ECPrivateKey && k2 instanceof ECPrivateKey) {
            return KeyUtils.compareECKeys((ECPrivateKey)ECPrivateKey.class.cast(k1), (ECPrivateKey)ECPrivateKey.class.cast(k2));
        }
        if (k1 != null && "EdDSA".equalsIgnoreCase(k1.getAlgorithm()) && k2 != null && "EdDSA".equalsIgnoreCase(k2.getAlgorithm())) {
            return SecurityUtils.compareEDDSAPrivateKeys(k1, k2);
        }
        return false;
    }

    public static boolean compareRSAKeys(RSAPublicKey k1, RSAPublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getPublicExponent(), k2.getPublicExponent()) && Objects.equals(k1.getModulus(), k2.getModulus());
    }

    public static boolean compareRSAKeys(RSAPrivateKey k1, RSAPrivateKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getModulus(), k2.getModulus()) && Objects.equals(k1.getPrivateExponent(), k2.getPrivateExponent());
    }

    public static boolean compareOpenSSHCertificateKeys(OpenSshCertificate k1, OpenSshCertificate k2) {
        if (k1 == k2) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getSerial(), k2.getSerial()) && Arrays.equals(k1.getSignature(), k2.getSignature()) && KeyUtils.compareKeys(k1.getCertPubKey(), k2.getCertPubKey());
    }

    public static RSAPublicKey recoverRSAPublicKey(RSAPrivateKey privateKey) throws GeneralSecurityException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            return KeyUtils.recoverFromRSAPrivateCrtKey((RSAPrivateCrtKey)privateKey);
        }
        return KeyUtils.recoverRSAPublicKey(privateKey.getModulus(), DEFAULT_RSA_PUBLIC_EXPONENT);
    }

    public static RSAPublicKey recoverFromRSAPrivateCrtKey(RSAPrivateCrtKey rsaKey) throws GeneralSecurityException {
        return KeyUtils.recoverRSAPublicKey(rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getPublicExponent());
    }

    public static RSAPublicKey recoverRSAPublicKey(BigInteger p, BigInteger q, BigInteger publicExponent) throws GeneralSecurityException {
        return KeyUtils.recoverRSAPublicKey(p.multiply(q), publicExponent);
    }

    public static RSAPublicKey recoverRSAPublicKey(BigInteger modulus, BigInteger publicExponent) throws GeneralSecurityException {
        KeyFactory kf = SecurityUtils.getKeyFactory(RSA_ALGORITHM);
        return (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
    }

    public static boolean compareDSAKeys(DSAPublicKey k1, DSAPublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getY(), k2.getY()) && KeyUtils.compareDSAParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareDSAKeys(DSAPrivateKey k1, DSAPrivateKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getX(), k2.getX()) && KeyUtils.compareDSAParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareDSAParams(DSAParams p1, DSAParams p2) {
        if (Objects.equals(p1, p2)) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return Objects.equals(p1.getG(), p2.getG()) && Objects.equals(p1.getP(), p2.getP()) && Objects.equals(p1.getQ(), p2.getQ());
    }

    public static DSAPublicKey recoverDSAPublicKey(DSAPrivateKey privateKey) throws GeneralSecurityException {
        DSAParams keyParams = privateKey.getParams();
        BigInteger p = keyParams.getP();
        BigInteger x = privateKey.getX();
        BigInteger q = keyParams.getQ();
        BigInteger g = keyParams.getG();
        BigInteger y = g.modPow(x, p);
        KeyFactory kf = SecurityUtils.getKeyFactory(DSS_ALGORITHM);
        return (DSAPublicKey)kf.generatePublic(new DSAPublicKeySpec(y, p, q, g));
    }

    public static boolean compareECKeys(ECPrivateKey k1, ECPrivateKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getS(), k2.getS()) && KeyUtils.compareECParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareECKeys(ECPublicKey k1, ECPublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getW(), k2.getW()) && KeyUtils.compareECParams(k1.getParams(), k2.getParams());
    }

    public static boolean compareECParams(ECParameterSpec s1, ECParameterSpec s2) {
        if (Objects.equals(s1, s2)) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return Objects.equals(s1.getOrder(), s2.getOrder()) && s1.getCofactor() == s2.getCofactor() && Objects.equals(s1.getGenerator(), s2.getGenerator()) && Objects.equals(s1.getCurve(), s2.getCurve());
    }

    public static boolean compareSkEcdsaKeys(SkEcdsaPublicKey k1, SkEcdsaPublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getAppName(), k2.getAppName()) && Objects.equals(k1.isNoTouchRequired(), k2.isNoTouchRequired()) && KeyUtils.compareECKeys(k1.getDelegatePublicKey(), k2.getDelegatePublicKey());
    }

    public static boolean compareSkEd25519Keys(SkED25519PublicKey k1, SkED25519PublicKey k2) {
        if (Objects.equals(k1, k2)) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        return Objects.equals(k1.getAppName(), k2.getAppName()) && Objects.equals(k1.isNoTouchRequired(), k2.isNoTouchRequired()) && SecurityUtils.compareEDDSAPPublicKeys(k1.getDelegatePublicKey(), k2.getDelegatePublicKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSignatureAlgorithm(String chosenAlgorithm, PublicKey key) {
        if (key instanceof OpenSshCertificate) {
            Map<String, String> map = SIGNATURE_ALGORITHM_MAP;
            synchronized (map) {
                return SIGNATURE_ALGORITHM_MAP.get(chosenAlgorithm);
            }
        }
        return chosenAlgorithm;
    }

    static {
        KeyUtils.registerPublicKeyEntryDecoder(OpenSSHCertificateDecoder.INSTANCE);
        KeyUtils.registerPublicKeyEntryDecoder(RSAPublicKeyDecoder.INSTANCE);
        KeyUtils.registerPublicKeyEntryDecoder(DSSPublicKeyEntryDecoder.INSTANCE);
        if (SecurityUtils.isECCSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(ECDSAPublicKeyEntryDecoder.INSTANCE);
        }
        if (SecurityUtils.isEDDSACurveSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(SecurityUtils.getEDDSAPublicKeyEntryDecoder());
        }
        if (SecurityUtils.isECCSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(SkECDSAPublicKeyEntryDecoder.INSTANCE);
        }
        if (SecurityUtils.isEDDSACurveSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(SkED25519PublicKeyEntryDecoder.INSTANCE);
        }
    }
}

