/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.PathUtils;

public class TestInputFileBuilder {
    private static int batchId = 1;
    private final int id;
    private final String relativePath;
    private String oldRelativePath;
    private final String projectKey;
    @CheckForNull
    private Path projectBaseDir;
    private Path moduleBaseDir;
    private String language;
    private InputFile.Type type = InputFile.Type.MAIN;
    private InputFile.Status status;
    private int lines = -1;
    private Charset charset;
    private String hash;
    private int nonBlankLines;
    private int[] originalLineStartOffsets = new int[0];
    private int[] originalLineEndOffsets = new int[0];
    private int lastValidOffset = -1;
    private boolean publish = true;
    private String contents;

    public TestInputFileBuilder(String projectKey, String relativePath) {
        this(projectKey, relativePath, batchId++);
    }

    public TestInputFileBuilder(String projectKey, File moduleBaseDir, File filePath) {
        String relativePathStr = moduleBaseDir.toPath().relativize(filePath.toPath()).toString();
        this.projectKey = projectKey;
        this.setModuleBaseDir(moduleBaseDir.toPath());
        this.relativePath = PathUtils.sanitize(relativePathStr);
        this.id = batchId++;
    }

    public TestInputFileBuilder(String projectKey, String relativePath, int id) {
        this.projectKey = projectKey;
        this.setModuleBaseDir(Paths.get(projectKey, new String[0]));
        this.relativePath = PathUtils.sanitize(relativePath);
        this.id = id;
    }

    public TestInputFileBuilder(String projectKey, String relativePath, String oldRelativePath, int id) {
        this.projectKey = projectKey;
        this.setModuleBaseDir(Paths.get(projectKey, new String[0]));
        this.relativePath = PathUtils.sanitize(relativePath);
        this.oldRelativePath = oldRelativePath;
        this.id = id;
    }

    public static TestInputFileBuilder create(String moduleKey, File moduleBaseDir, File filePath) {
        return new TestInputFileBuilder(moduleKey, moduleBaseDir, filePath);
    }

    public static TestInputFileBuilder create(String moduleKey, String relativePath) {
        return new TestInputFileBuilder(moduleKey, relativePath);
    }

    public static int nextBatchId() {
        return batchId++;
    }

    public TestInputFileBuilder setProjectBaseDir(Path projectBaseDir) {
        this.projectBaseDir = TestInputFileBuilder.normalize(projectBaseDir);
        return this;
    }

    public TestInputFileBuilder setModuleBaseDir(Path moduleBaseDir) {
        this.moduleBaseDir = TestInputFileBuilder.normalize(moduleBaseDir);
        return this;
    }

    private static Path normalize(Path path) {
        try {
            return path.normalize().toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            return path.normalize();
        }
    }

    public TestInputFileBuilder setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    public TestInputFileBuilder setType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    public TestInputFileBuilder setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public TestInputFileBuilder setLines(int lines) {
        this.lines = lines;
        return this;
    }

    public TestInputFileBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public TestInputFileBuilder setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public TestInputFileBuilder setContents(String content) {
        this.contents = content;
        this.initMetadata(content);
        return this;
    }

    public TestInputFileBuilder setNonBlankLines(int nonBlankLines) {
        this.nonBlankLines = nonBlankLines;
        return this;
    }

    public TestInputFileBuilder setLastValidOffset(int lastValidOffset) {
        this.lastValidOffset = lastValidOffset;
        return this;
    }

    public TestInputFileBuilder setOriginalLineStartOffsets(int[] originalLineStartOffsets) {
        this.originalLineStartOffsets = originalLineStartOffsets;
        return this;
    }

    public TestInputFileBuilder setOriginalLineEndOffsets(int[] originalLineEndOffsets) {
        this.originalLineEndOffsets = originalLineEndOffsets;
        return this;
    }

    public TestInputFileBuilder setPublish(boolean publish) {
        this.publish = publish;
        return this;
    }

    public TestInputFileBuilder setMetadata(Metadata metadata) {
        this.setLines(metadata.lines());
        this.setLastValidOffset(metadata.lastValidOffset());
        this.setNonBlankLines(metadata.nonBlankLines());
        this.setHash(metadata.hash());
        this.setOriginalLineStartOffsets(metadata.originalLineStartOffsets());
        this.setOriginalLineEndOffsets(metadata.originalLineEndOffsets());
        return this;
    }

    public TestInputFileBuilder initMetadata(String content) {
        AnalysisWarnings analysisWarnings = warning -> {};
        return this.setMetadata(new FileMetadata(analysisWarnings).readMetadata(new StringReader(content)));
    }

    public DefaultInputFile build() {
        Path absolutePath = this.moduleBaseDir.resolve(this.relativePath);
        if (this.projectBaseDir == null) {
            this.projectBaseDir = this.moduleBaseDir;
        }
        String projectRelativePath = this.projectBaseDir.relativize(absolutePath).toString();
        DefaultIndexedFile indexedFile = new DefaultIndexedFile(absolutePath, this.projectKey, projectRelativePath, this.relativePath, this.type, this.language, this.id, new SensorStrategy(), this.oldRelativePath);
        DefaultInputFile inputFile = new DefaultInputFile(indexedFile, f -> f.setMetadata(new Metadata(this.lines, this.nonBlankLines, this.hash, this.originalLineStartOffsets, this.originalLineEndOffsets, this.lastValidOffset)), this.contents, f -> {});
        inputFile.setStatus(this.status);
        inputFile.setCharset(this.charset);
        inputFile.setPublished(this.publish);
        return inputFile;
    }

    public static DefaultInputModule newDefaultInputModule(String moduleKey, File baseDir) {
        ProjectDefinition definition = ProjectDefinition.create().setKey(moduleKey).setBaseDir(baseDir).setWorkDir(new File(baseDir, ".sonar"));
        return TestInputFileBuilder.newDefaultInputModule(definition);
    }

    public static DefaultInputModule newDefaultInputModule(ProjectDefinition projectDefinition) {
        return new DefaultInputModule(projectDefinition, TestInputFileBuilder.nextBatchId());
    }

    public static DefaultInputModule newDefaultInputModule(AbstractProjectOrModule parent, String key) throws IOException {
        Path basedir = parent.getBaseDir().resolve(key);
        Files.createDirectory(basedir, new FileAttribute[0]);
        return TestInputFileBuilder.newDefaultInputModule(key, basedir.toFile());
    }

    public static DefaultInputProject newDefaultInputProject(String projectKey, File baseDir) {
        ProjectDefinition definition = ProjectDefinition.create().setKey(projectKey).setBaseDir(baseDir).setWorkDir(new File(baseDir, ".sonar"));
        return TestInputFileBuilder.newDefaultInputProject(definition);
    }

    public static DefaultInputProject newDefaultInputProject(ProjectDefinition projectDefinition) {
        return new DefaultInputProject(projectDefinition, TestInputFileBuilder.nextBatchId());
    }

    public static DefaultInputProject newDefaultInputProject(String key, Path baseDir) throws IOException {
        Files.createDirectory(baseDir, new FileAttribute[0]);
        return TestInputFileBuilder.newDefaultInputProject(key, baseDir.toFile());
    }

    public static DefaultInputDir newDefaultInputDir(AbstractProjectOrModule module, String relativePath) throws IOException {
        Path basedir = module.getBaseDir().resolve(relativePath);
        Files.createDirectory(basedir, new FileAttribute[0]);
        return new DefaultInputDir(module.key(), relativePath).setModuleBaseDir(module.getBaseDir());
    }

    public static DefaultInputFile newDefaultInputFile(Path projectBaseDir, AbstractProjectOrModule module, String relativePath) {
        return new TestInputFileBuilder(module.key(), relativePath).setStatus(InputFile.Status.SAME).setProjectBaseDir(projectBaseDir).setModuleBaseDir(module.getBaseDir()).build();
    }
}

