/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.fix.NewQuickFix;
import org.sonar.api.batch.sensor.issue.fix.QuickFix;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.batch.sensor.issue.internal.NoOpNewQuickFix;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Preconditions;

public class DefaultIssue
extends AbstractDefaultIssue<DefaultIssue>
implements Issue,
NewIssue {
    private final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> overridenImpacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);
    private RuleKey ruleKey;
    private Double gap;
    private Severity overriddenSeverity;
    private boolean quickFixAvailable = false;
    private String ruleDescriptionContextKey;
    private List<String> codeVariants;

    public DefaultIssue(DefaultInputProject project) {
        this(project, null);
    }

    public DefaultIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(project, storage);
    }

    @Override
    public DefaultIssue forRule(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    public DefaultIssue gap(@Nullable Double gap) {
        Preconditions.checkArgument(gap == null || gap >= 0.0, String.format("Gap must be greater than or equal 0 (got %s)", gap));
        this.gap = gap;
        return this;
    }

    @Override
    public DefaultIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    @Override
    public DefaultIssue overrideImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
        this.overridenImpacts.put(softwareQuality, severity);
        return this;
    }

    @Override
    public DefaultIssue setQuickFixAvailable(boolean quickFixAvailable) {
        this.quickFixAvailable = quickFixAvailable;
        return this;
    }

    @Override
    public NewQuickFix newQuickFix() {
        return new NoOpNewQuickFix();
    }

    @Override
    public NewIssue addQuickFix(NewQuickFix newQuickFix) {
        this.quickFixAvailable = true;
        return this;
    }

    @Override
    public DefaultIssue setRuleDescriptionContextKey(@Nullable String ruleDescriptionContextKey) {
        this.ruleDescriptionContextKey = ruleDescriptionContextKey;
        return this;
    }

    @Override
    public DefaultIssue setCodeVariants(@Nullable Iterable<String> codeVariants) {
        if (codeVariants != null) {
            ArrayList<String> codeVariantsList = new ArrayList<String>();
            codeVariants.forEach(codeVariantsList::add);
            this.codeVariants = codeVariantsList;
        }
        return this;
    }

    @Override
    public boolean isQuickFixAvailable() {
        return this.quickFixAvailable;
    }

    @Override
    public Optional<String> ruleDescriptionContextKey() {
        return Optional.ofNullable(this.ruleDescriptionContextKey);
    }

    @Override
    public List<QuickFix> quickFixes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> codeVariants() {
        return this.codeVariants;
    }

    @Override
    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    @Override
    public Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> overridenImpacts() {
        return this.overridenImpacts;
    }

    @Override
    public Double gap() {
        return this.gap;
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "ruleKey is mandatory on issue");
        Preconditions.checkState(this.primaryLocation != null, "Primary location is mandatory on every issue");
        this.storage.store(this);
    }
}

