/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.MessageFormatting;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.NewMessageFormatting;
import org.sonar.api.batch.sensor.issue.internal.DefaultMessageFormatting;
import org.sonar.api.utils.Preconditions;

public class DefaultIssueLocation
implements NewIssueLocation,
IssueLocation {
    private static final String NULL_CHARACTER = "\u0000";
    private static final String NULL_REPLACEMENT = "[NULL]";
    private InputComponent component;
    private TextRange textRange;
    private String message;
    private final List<MessageFormatting> messageFormattings = new ArrayList<MessageFormatting>();

    @Override
    public DefaultIssueLocation on(InputComponent component) {
        Preconditions.checkArgument(component != null, "Component can't be null");
        Preconditions.checkState(this.component == null, "on() already called");
        this.component = component;
        return this;
    }

    @Override
    public DefaultIssueLocation at(TextRange location) {
        Preconditions.checkState(this.component != null, "at() should be called after on()");
        Preconditions.checkState(this.component.isFile(), "at() should be called only for an InputFile.");
        DefaultInputFile file = (DefaultInputFile)this.component;
        file.validate(location);
        this.textRange = location;
        return this;
    }

    @Override
    public DefaultIssueLocation message(String message) {
        DefaultIssueLocation.validateMessage(message);
        String sanitizedMessage = DefaultIssueLocation.sanitizeNulls(message);
        this.message = StringUtils.abbreviate(StringUtils.trim(sanitizedMessage), 1333);
        return this;
    }

    @Override
    public DefaultIssueLocation message(String message, List<NewMessageFormatting> newMessageFormattings) {
        DefaultIssueLocation.validateMessage(message);
        DefaultIssueLocation.validateFormattings(newMessageFormattings, message);
        String sanitizedMessage = DefaultIssueLocation.sanitizeNulls(message);
        this.message = StringUtils.abbreviate(sanitizedMessage, 1333);
        for (NewMessageFormatting newMessageFormatting : newMessageFormattings) {
            DefaultMessageFormatting messageFormatting = (DefaultMessageFormatting)newMessageFormatting;
            if (messageFormatting.start() > 1333) continue;
            if (messageFormatting.end() > 1333) {
                messageFormatting = new DefaultMessageFormatting().start(messageFormatting.start()).end(1333).type(messageFormatting.type());
            }
            this.messageFormattings.add(messageFormatting);
        }
        return this;
    }

    private static void validateFormattings(List<NewMessageFormatting> newMessageFormattings, String message) {
        Preconditions.checkArgument(newMessageFormattings != null, "messageFormattings can't be null");
        newMessageFormattings.stream().map(DefaultMessageFormatting.class::cast).forEach(e -> e.validate(message));
    }

    private static void validateMessage(String message) {
        Objects.requireNonNull(message, "Message can't be null");
    }

    private static String sanitizeNulls(String message) {
        return StringUtils.replace(message, NULL_CHARACTER, NULL_REPLACEMENT);
    }

    @Override
    public NewMessageFormatting newMessageFormatting() {
        return new DefaultMessageFormatting();
    }

    @Override
    public InputComponent inputComponent() {
        return this.component;
    }

    @Override
    public TextRange textRange() {
        return this.textRange;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public List<MessageFormatting> messageFormattings() {
        return this.messageFormattings;
    }
}

