/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.testfixtures.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.sonar.api.testfixtures.log.ConcurrentListAppender;
import org.sonar.api.testfixtures.log.LogAndArguments;
import org.sonar.api.utils.log.LoggerLevel;

class AbstractLogTester<G extends AbstractLogTester<G>> {
    private static final Map<LoggerLevel, org.slf4j.event.Level> sonarToSlf4jLevel = Map.of(LoggerLevel.TRACE, org.slf4j.event.Level.TRACE, LoggerLevel.DEBUG, org.slf4j.event.Level.DEBUG, LoggerLevel.INFO, org.slf4j.event.Level.INFO, LoggerLevel.WARN, org.slf4j.event.Level.WARN, LoggerLevel.ERROR, org.slf4j.event.Level.ERROR);
    private static final Map<org.slf4j.event.Level, LoggerLevel> slf4jToSonarLevel = Map.of(org.slf4j.event.Level.TRACE, LoggerLevel.TRACE, org.slf4j.event.Level.DEBUG, LoggerLevel.DEBUG, org.slf4j.event.Level.INFO, LoggerLevel.INFO, org.slf4j.event.Level.WARN, LoggerLevel.WARN, org.slf4j.event.Level.ERROR, LoggerLevel.ERROR);
    private final ConcurrentListAppender<ILoggingEvent> listAppender = new ConcurrentListAppender();

    protected AbstractLogTester() {
        this.setLevel(org.slf4j.event.Level.INFO);
    }

    protected void before() {
        AbstractLogTester.getRootLogger().addAppender((Appender<ILoggingEvent>)this.listAppender);
        this.listAppender.start();
    }

    protected void after() {
        this.listAppender.stop();
        this.listAppender.list.clear();
        AbstractLogTester.getRootLogger().detachAppender((Appender<ILoggingEvent>)this.listAppender);
        this.setLevel(org.slf4j.event.Level.INFO);
    }

    LoggerLevel getLevel() {
        return slf4jToSonarLevel.get((Object)AbstractLogTester.toSlf4j(AbstractLogTester.getRootLogger().getLevel()));
    }

    private static org.slf4j.event.Level toSlf4j(Level level) {
        int slf4jIntLevel = Level.toLocationAwareLoggerInteger(level);
        return Arrays.stream(org.slf4j.event.Level.values()).filter(l -> l.toInt() == slf4jIntLevel).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported level: " + level));
    }

    public G setLevel(org.slf4j.event.Level level) {
        AbstractLogTester.getRootLogger().setLevel(Level.fromLocationAwareLoggerInteger(level.toInt()));
        return (G)this;
    }

    @Deprecated(since="9.15")
    public G setLevel(LoggerLevel sonarLevel) {
        return this.setLevel(sonarToSlf4jLevel.get((Object)sonarLevel));
    }

    private static Logger getRootLogger() {
        return (Logger)LoggerFactory.getLogger("ROOT");
    }

    public List<String> logs() {
        return this.listAppender.list.stream().map(e -> (LoggingEvent)e).map(LoggingEvent::getFormattedMessage).collect(Collectors.toList());
    }

    public List<String> logs(org.slf4j.event.Level level) {
        return this.listAppender.list.stream().map(e -> (LoggingEvent)e).filter(e -> e.getLevel().equals(Level.fromLocationAwareLoggerInteger(level.toInt()))).map(LoggingEvent::getFormattedMessage).collect(Collectors.toList());
    }

    @Deprecated(since="9.15")
    public List<String> logs(LoggerLevel sonarLevel) {
        return this.logs(sonarToSlf4jLevel.get((Object)sonarLevel));
    }

    public List<LogAndArguments> getLogs() {
        return this.listAppender.list.stream().map(e -> (LoggingEvent)e).map(AbstractLogTester::convert).collect(Collectors.toList());
    }

    public List<LogAndArguments> getLogs(org.slf4j.event.Level level) {
        return this.listAppender.list.stream().map(e -> (LoggingEvent)e).filter(e -> e.getLevel().equals(Level.fromLocationAwareLoggerInteger(level.toInt()))).map(AbstractLogTester::convert).collect(Collectors.toList());
    }

    @Deprecated(since="9.15")
    public List<LogAndArguments> getLogs(LoggerLevel sonarLevel) {
        return this.getLogs(sonarToSlf4jLevel.get((Object)sonarLevel));
    }

    private static LogAndArguments convert(LoggingEvent e) {
        return new LogAndArguments(e.getFormattedMessage(), e.getMessage(), e.getThrowableProxy(), e.getArgumentArray());
    }

    public G clear() {
        this.listAppender.list.clear();
        return (G)this;
    }
}

