/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.testfixtures.log;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class LogAndArguments {
    private final String rawMsg;
    private final Throwable throwable;
    private final Object[] args;
    private final String msg;

    LogAndArguments(String msg, String rawMsg, @Nullable IThrowableProxy t, Object ... args2) {
        this.rawMsg = rawMsg;
        this.msg = msg;
        this.throwable = t instanceof ThrowableProxy ? ((ThrowableProxy)t).getThrowable() : null;
        this.args = args2;
    }

    @CheckForNull
    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getRawMsg() {
        return this.rawMsg;
    }

    public Optional<Object[]> getArgs() {
        return Optional.ofNullable(this.args);
    }

    public String getFormattedMsg() {
        return this.msg;
    }

    public String toString() {
        String throwableStr = this.throwable != null ? this.throwable.getClass().getName() + ": " + this.throwable.getMessage() : null;
        return "LogAndArguments{rawMsg='" + this.rawMsg + "', args=" + Arrays.toString(this.args) + ", msg='" + this.msg + "', throwable='" + throwableStr + "'}";
    }
}

