/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.io.FileUtils;
import org.sonar.api.internal.apachecommons.io.IOUtils;

public final class ZipUtils {
    private static final String ERROR_CREATING_DIRECTORY = "Error creating directory: ";

    private ZipUtils() {
    }

    public static File unzip(File zip2, File toDir) throws IOException {
        return ZipUtils.unzip(zip2, toDir, (ZipEntry ze) -> true);
    }

    public static File unzip(InputStream zip2, File toDir) throws IOException {
        return ZipUtils.unzip(zip2, toDir, (ZipEntry ze) -> true);
    }

    public static File unzip(InputStream zip2, File toDir, long unzipSizeThreshold) throws IOException {
        return ZipUtils.unzip(zip2, toDir, unzipSizeThreshold, ze -> true);
    }

    public static File unzip(InputStream stream, File toDir, Predicate<ZipEntry> filter) throws IOException {
        return ZipUtils.unzip(stream, toDir, null, filter);
    }

    public static File unzip(InputStream stream, File toDir, @Nullable Long unzipSizeThreshold, Predicate<ZipEntry> filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        long totalSizeArchive = 0L;
        Path targetDirNormalizedPath = toDir.toPath().normalize();
        try (ZipInputStream zipStream = new ZipInputStream(stream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                File target;
                if (!filter.test(entry) || (target = ZipUtils.getTargetFile(entry, targetDirNormalizedPath)).isDirectory()) continue;
                if (unzipSizeThreshold != null) {
                    totalSizeArchive = ZipUtils.extractZipEntry(zipStream, target, totalSizeArchive, unzipSizeThreshold);
                    continue;
                }
                ZipUtils.copy(zipStream, target);
            }
            File file = toDir;
            return file;
        }
    }

    private static long extractZipEntry(ZipInputStream zipStream, File target, long totalSizeArchive, long threshold) throws IOException {
        int nBytes = -1;
        byte[] buffer = new byte[8192];
        try (FileOutputStream outputStream2 = new FileOutputStream(target);){
            while (-1 != (nBytes = zipStream.read(buffer))) {
                ((OutputStream)outputStream2).write(buffer, 0, nBytes);
                if ((totalSizeArchive += (long)nBytes) <= threshold) continue;
                throw new IllegalStateException(String.format("Decompression failed because unzipped size reached threshold: %s bytes", threshold));
            }
        }
        return totalSizeArchive;
    }

    private static File getTargetFile(ZipEntry entry, Path targetDirNormalized) throws IOException {
        File to = targetDirNormalized.resolve(entry.getName()).toFile();
        ZipUtils.verifyInsideTargetDirectory(entry, to.toPath(), targetDirNormalized);
        if (entry.isDirectory()) {
            ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
        } else {
            File parent = to.getParentFile();
            ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
        }
        return to;
    }

    private static void throwExceptionIfDirectoryIsNotCreatable(File to) throws IOException {
        if (!to.exists() && !to.mkdirs()) {
            throw new IOException(ERROR_CREATING_DIRECTORY + to);
        }
    }

    public static File unzip(File zip2, File toDir, Predicate<ZipEntry> filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        Path targetDirNormalizedPath = toDir.toPath().normalize();
        try (ZipFile zipFile = new ZipFile(zip2);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!filter.test(entry)) continue;
                File target = new File(toDir, entry.getName());
                ZipUtils.verifyInsideTargetDirectory(entry, target.toPath(), targetDirNormalizedPath);
                if (entry.isDirectory()) {
                    ZipUtils.throwExceptionIfDirectoryIsNotCreatable(target);
                    continue;
                }
                File parent = target.getParentFile();
                ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
                ZipUtils.copy(zipFile, entry, target);
            }
            File file = toDir;
            return file;
        }
    }

    private static void copy(ZipInputStream zipStream, File to) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(to);){
            IOUtils.copy((InputStream)zipStream, (OutputStream)fos);
        }
    }

    private static void copy(ZipFile zipFile, ZipEntry entry, File to) throws IOException {
        try (InputStream input = zipFile.getInputStream(entry);
             FileOutputStream fos = new FileOutputStream(to);){
            IOUtils.copy(input, (OutputStream)fos);
        }
    }

    public static void zipDir(File dir, File zip2) throws IOException {
        try (OutputStream out = Files.newOutputStream(zip2.toPath(), new OpenOption[0]);
             ZipOutputStream zout = new ZipOutputStream(out);){
            ZipUtils.doZipDir(dir, zout);
        }
    }

    private static void doZip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        IOUtils.copy(in, (OutputStream)out);
        out.closeEntry();
    }

    private static void doZip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            entryName = (String)entryName + "/";
            ZipEntry entry = new ZipEntry((String)entryName);
            out.putNextEntry(entry);
            out.closeEntry();
            File[] files = file.listFiles();
            if (files == null) {
                throw new IllegalStateException("Fail to list files of directory " + file.getAbsolutePath());
            }
            for (File f : files) {
                ZipUtils.doZip((String)entryName + f.getName(), f, out);
            }
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ZipUtils.doZip((String)entryName, in, out);
            }
        }
    }

    private static void doZipDir(File dir, ZipOutputStream out) throws IOException {
        File[] children = dir.listFiles();
        if (children == null) {
            throw new IllegalStateException("Fail to list files of directory " + dir.getAbsolutePath());
        }
        for (File child : children) {
            ZipUtils.doZip(child.getName(), child, out);
        }
    }

    private static void verifyInsideTargetDirectory(ZipEntry entry, Path entryPath, Path targetDirNormalizedPath) {
        if (!entryPath.normalize().startsWith(targetDirNormalizedPath)) {
            throw new IllegalStateException("Unzipping an entry outside the target directory is not allowed: " + entry.getName());
        }
    }
}

