/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.documentation;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.Version;
import org.sonar.core.documentation.DocumentationLinkGenerator;
import org.sonar.core.platform.SonarQubeVersion;

public class DefaultDocumentationLinkGenerator
implements DocumentationLinkGenerator {
    public static final String DOCUMENTATION_PUBLIC_URL = "https://docs.sonarsource.com/sonarqube/";
    private final String documentationBaseUrl;

    public DefaultDocumentationLinkGenerator(SonarQubeVersion sonarQubeVersion, Configuration configuration) {
        this.documentationBaseUrl = DefaultDocumentationLinkGenerator.completeUrl(configuration.get("sonar.documentation.baseUrl").orElse(DOCUMENTATION_PUBLIC_URL), sonarQubeVersion.get());
    }

    private static String completeUrl(String baseUrl, Version version) {
        Object url = baseUrl;
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = version.qualifier().equals("SNAPSHOT") ? (String)url + "latest" : (String)url + version.major() + "." + version.minor();
        return url;
    }

    @Override
    public String getDocumentationLink(@Nullable String suffix) {
        return this.documentationBaseUrl + Optional.ofNullable(suffix).orElse("");
    }
}

