/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Startable;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.System2;
import org.sonar.core.i18n.DurationLabel;
import org.sonar.core.i18n.I18n;
import org.sonar.core.i18n.I18nClassloader;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;

public class DefaultI18n
implements I18n,
Startable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultI18n.class);
    private static final String BUNDLE_PACKAGE = "org.sonar.l10n.";
    private final PluginRepository pluginRepository;
    private final ResourceBundle.Control control;
    private final System2 system2;
    private ClassLoader classloader;
    private Map<String, String> propertyToBundles;

    public DefaultI18n(PluginRepository pluginRepository, System2 system2) {
        this.pluginRepository = pluginRepository;
        this.system2 = system2;
        this.control = new ResourceBundle.Control(){

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                Preconditions.checkNotNull(baseName);
                Locale defaultLocale = Locale.ENGLISH;
                return locale.equals(defaultLocale) ? null : defaultLocale;
            }
        };
    }

    @Override
    public void start() {
        this.doStart(new I18nClassloader(this.pluginRepository));
    }

    @VisibleForTesting
    protected void doStart(ClassLoader classloader) {
        this.classloader = classloader;
        this.propertyToBundles = new HashMap<String, String>();
        this.initialize();
        LOG.debug("Loaded {} properties from l10n bundles", (Object)this.propertyToBundles.size());
    }

    protected void initialize() {
        this.initPlugin("core");
        Collection<PluginInfo> infos = this.pluginRepository.getPluginInfos();
        for (PluginInfo plugin : infos) {
            this.initPlugin(plugin.getKey());
        }
    }

    protected void initPlugin(String pluginKey) {
        try {
            String bundleKey = BUNDLE_PACKAGE + pluginKey;
            ResourceBundle bundle = ResourceBundle.getBundle(bundleKey, Locale.ENGLISH, this.classloader, this.control);
            Enumeration<String> keys2 = bundle.getKeys();
            while (keys2.hasMoreElements()) {
                String key = keys2.nextElement();
                this.propertyToBundles.put(key, bundleKey);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        if (this.classloader instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Object)this.classloader));
        }
        this.classloader = null;
        this.propertyToBundles = null;
    }

    @Override
    @CheckForNull
    public String message(Locale locale, String key, @Nullable String defaultValue, Object ... parameters) {
        String bundleKey = this.propertyToBundles.get(key);
        String value = null;
        if (bundleKey != null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleKey, locale, this.classloader, this.control);
                value = resourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        return DefaultI18n.formatMessage(value, parameters);
    }

    @Override
    public String age(Locale locale, long durationInMillis) {
        DurationLabel.Result duration = DurationLabel.label(durationInMillis);
        return this.message(locale, duration.key(), null, duration.value());
    }

    @Override
    public String age(Locale locale, Date fromDate, Date toDate) {
        return this.age(locale, toDate.getTime() - fromDate.getTime());
    }

    @Override
    public String ageFromNow(Locale locale, Date date) {
        return this.age(locale, this.system2.now() - date.getTime());
    }

    @Override
    public String formatDateTime(Locale locale, Date date) {
        return DateFormat.getDateTimeInstance(2, 3, locale).format(date);
    }

    @Override
    public String formatDate(Locale locale, Date date) {
        return DateFormat.getDateInstance(2, locale).format(date);
    }

    @Override
    public String formatDouble(Locale locale, Double value) {
        NumberFormat format = DecimalFormat.getNumberInstance(locale);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        return format.format(value);
    }

    @Override
    public String formatInteger(Locale locale, Integer value) {
        return NumberFormat.getNumberInstance(locale).format(value);
    }

    String messageFromFile(Locale locale, String filename, String relatedProperty) {
        InputStream input;
        String result = null;
        String bundleBase = this.propertyToBundles.get(relatedProperty);
        if (bundleBase == null) {
            return null;
        }
        Object filePath = bundleBase.replace('.', '/');
        if (!"en".equals(locale.getLanguage())) {
            filePath = (String)filePath + "_" + locale.getLanguage();
        }
        if ((input = this.classloader.getResourceAsStream((String)(filePath = (String)filePath + "/" + filename))) != null) {
            result = DefaultI18n.readInputStream((String)filePath, input);
        }
        return result;
    }

    private static String readInputStream(String filePath, InputStream input) {
        String result;
        try {
            result = IOUtils.toString(input, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SonarException("Fail to load file: " + filePath, e);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        return result;
    }

    public Set<String> getPropertyKeys() {
        return this.propertyToBundles.keySet();
    }

    public Locale getEffectiveLocale(Locale locale) {
        Locale bundleLocale = ResourceBundle.getBundle("org.sonar.l10n.core", locale, this.classloader, this.control).getLocale();
        locale.getISO3Language();
        return bundleLocale.getLanguage().isEmpty() ? Locale.ENGLISH : bundleLocale;
    }

    @CheckForNull
    private static String formatMessage(@Nullable String message, Object ... parameters) {
        if (message == null || parameters.length == 0) {
            return message;
        }
        return MessageFormat.format(message.replaceAll("'", "''"), parameters);
    }
}

