/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.core.issue.tracking.AbstractTracker;
import org.sonar.core.issue.tracking.BlockRecognizer;
import org.sonar.core.issue.tracking.FilteringBaseInputWrapper;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.NonClosedTracking;
import org.sonar.core.issue.tracking.Trackable;
import org.sonar.core.issue.tracking.Tracking;

@ScannerSide
public class Tracker<RAW extends Trackable, BASE extends Trackable>
extends AbstractTracker<RAW, BASE> {
    public NonClosedTracking<RAW, BASE> trackNonClosed(Input<RAW> rawInput, Input<BASE> baseInput) {
        NonClosedTracking<RAW, BASE> tracking = NonClosedTracking.of(rawInput, baseInput);
        this.match(tracking, AbstractTracker.LineAndLineHashAndMessage::new);
        this.match(tracking, AbstractTracker.LineAndLineHashKey::new);
        this.detectCodeMoves(rawInput, baseInput, tracking);
        this.match(tracking, AbstractTracker.LineHashAndMessageKey::new);
        this.match(tracking, AbstractTracker.LineAndMessageKey::new);
        this.match(tracking, AbstractTracker.LineHashKey::new);
        return tracking;
    }

    public Tracking<RAW, BASE> trackClosed(NonClosedTracking<RAW, BASE> nonClosedTracking, Input<BASE> baseInput) {
        ClosedTracking<RAW, BASE> closedTracking = ClosedTracking.of(nonClosedTracking, baseInput);
        this.match(closedTracking, AbstractTracker.LineAndLineHashAndMessage::new);
        return this.mergedTracking(nonClosedTracking, closedTracking);
    }

    private void detectCodeMoves(Input<RAW> rawInput, Input<BASE> baseInput, Tracking<RAW, BASE> tracking) {
        if (!tracking.isComplete()) {
            new BlockRecognizer<RAW, BASE>().match(rawInput, baseInput, tracking);
        }
    }

    private Tracking<RAW, BASE> mergedTracking(NonClosedTracking<RAW, BASE> nonClosedTracking, ClosedTracking<RAW, BASE> closedTracking) {
        return new Tracking<RAW, BASE>(nonClosedTracking.getRawInput().getIssues(), Tracker.concatIssues(nonClosedTracking, closedTracking), closedTracking.rawToBase, closedTracking.baseToRaw);
    }

    private static <RAW extends Trackable, BASE extends Trackable> List<BASE> concatIssues(NonClosedTracking<RAW, BASE> nonClosedTracking, ClosedTracking<RAW, BASE> closedTracking) {
        Collection<BASE> nonClosedIssues = nonClosedTracking.getBaseInput().getIssues();
        Collection<BASE> closeIssues = closedTracking.getBaseInput().getIssues();
        return Stream.concat(nonClosedIssues.stream(), closeIssues.stream()).collect(Collectors.toList());
    }

    private static class ClosedTracking<RAW extends Trackable, BASE extends Trackable>
    extends Tracking<RAW, BASE> {
        private final Input<BASE> baseInput;

        ClosedTracking(NonClosedTracking<RAW, BASE> nonClosedTracking, Input<BASE> closedBaseInput) {
            super(nonClosedTracking.getRawInput().getIssues(), closedBaseInput.getIssues(), nonClosedTracking.rawToBase, nonClosedTracking.baseToRaw);
            this.baseInput = closedBaseInput;
        }

        public static <RAW extends Trackable, BASE extends Trackable> ClosedTracking<RAW, BASE> of(NonClosedTracking<RAW, BASE> nonClosedTracking, Input<BASE> baseInput) {
            FilteringBaseInputWrapper<Trackable> closedBaseInput = new FilteringBaseInputWrapper<Trackable>(baseInput, t -> "CLOSED".equals(t.getStatus()));
            return new ClosedTracking<RAW, Trackable>(nonClosedTracking, closedBaseInput);
        }

        public Input<BASE> getBaseInput() {
            return this.baseInput;
        }
    }
}

