/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.core.util.Uuids;

public class ComponentKeys {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentKeys.class);
    private static final Pattern IDENTITY_HASH_PATTERN = Pattern.compile(".+@[a-f0-9]+");
    private final Set<Class> objectsWithoutToString = new HashSet<Class>();

    Object of(Object component) {
        return this.of(component, LOG);
    }

    Object of(Object component, Logger log) {
        if (component instanceof Class) {
            return component;
        }
        return this.ofInstance(component, log);
    }

    public String ofInstance(Object component) {
        return this.ofInstance(component, LOG);
    }

    public String ofClass(Class<?> clazz) {
        return clazz.getClassLoader() + "-" + clazz.getCanonicalName();
    }

    String ofInstance(Object component, Logger log) {
        Object key = component.toString();
        if (IDENTITY_HASH_PATTERN.matcher((CharSequence)key).matches()) {
            if (!this.objectsWithoutToString.add(component.getClass())) {
                log.warn(String.format("Bad component key: %s. Please implement toString() method on class %s", key, component.getClass().getName()));
            }
            key = (String)key + Uuids.create();
        }
        return this.ofClass(component.getClass()) + "-" + (String)key;
    }
}

