/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.core.util.FileUtils;
import org.sonarqube.ws.client.OkHttpClientBuilder;

public class DefaultHttpDownloader
extends HttpDownloader {
    private final OkHttpClient client;

    @Inject
    public DefaultHttpDownloader(Server server, Configuration config) {
        this(server, config, null, null);
    }

    public DefaultHttpDownloader(Server server, Configuration config, @Nullable Integer connectTimeout, @Nullable Integer readTimeout) {
        this.client = DefaultHttpDownloader.buildHttpClient(server, config, connectTimeout, readTimeout);
    }

    private static OkHttpClient buildHttpClient(Server server, Configuration config, @Nullable Integer connectTimeout, @Nullable Integer readTimeout) {
        OkHttpClientBuilder clientBuilder = new OkHttpClientBuilder().setFollowRedirects(true).setUserAgent(DefaultHttpDownloader.getUserAgent(server, config));
        if (connectTimeout != null) {
            clientBuilder.setConnectTimeoutMs(connectTimeout.intValue());
        }
        if (readTimeout != null) {
            clientBuilder.setReadTimeoutMs(readTimeout.intValue());
        }
        return clientBuilder.build();
    }

    private static String getUserAgent(Server server, Configuration config) {
        Optional<String> serverId = config.get("sonar.core.id");
        if (serverId.isEmpty()) {
            return String.format("SonarQube %s #", server.getVersion());
        }
        return String.format("SonarQube %s # %s", server.getVersion(), serverId.get());
    }

    @Override
    protected String description(URI uri) {
        return uri.toString();
    }

    @Override
    protected String[] getSupportedSchemes() {
        return new String[]{"http", "https"};
    }

    @Override
    protected byte[] readBytes(URI uri) {
        return this.download(uri);
    }

    @Override
    protected String readString(URI uri, Charset charset) {
        Response response = this.executeCall(uri);
        try {
            String string = IOUtils.toString(response.body().byteStream(), charset);
            if (response != null) {
                response.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw DefaultHttpDownloader.failToDownload(uri, e);
            }
        }
    }

    @Override
    public String downloadPlainText(URI uri, String encoding) {
        return this.readString(uri, Charset.forName(encoding));
    }

    @Override
    public byte[] download(URI uri) {
        Response response = this.executeCall(uri);
        try {
            byte[] byArray = ByteStreams.toByteArray(response.body().byteStream());
            if (response != null) {
                response.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw DefaultHttpDownloader.failToDownload(uri, e);
            }
        }
    }

    @Override
    public InputStream openStream(URI uri) {
        try {
            Response response = this.executeCall(uri);
            return response.body().byteStream();
        }
        catch (IOException e) {
            throw DefaultHttpDownloader.failToDownload(uri, e);
        }
    }

    @Override
    public void download(URI uri, File toFile) {
        try (Response response = this.executeCall(uri);){
            org.apache.commons.io.FileUtils.copyInputStreamToFile(response.body().byteStream(), toFile);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly(toFile);
            throw DefaultHttpDownloader.failToDownload(uri, e);
        }
    }

    private Response executeCall(URI uri) throws IOException {
        Request request = new Request.Builder().url(uri.toURL()).get().build();
        return this.client.newCall(request).execute();
    }

    private static SonarException failToDownload(URI uri, IOException e) {
        throw new SonarException(String.format("Fail to download: %s", uri), e);
    }
}

