/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util.logs;

import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.sonar.core.util.logs.DefaultProfiler;
import org.sonar.core.util.logs.NullProfiler;

public abstract class Profiler {
    public static Profiler create(Logger logger) {
        return new DefaultProfiler(logger);
    }

    public static Profiler createIfTrace(Logger logger) {
        if (logger.isTraceEnabled()) {
            return Profiler.create(logger);
        }
        return NullProfiler.NULL_INSTANCE;
    }

    public static Profiler createIfDebug(Logger logger) {
        if (logger.isDebugEnabled()) {
            return Profiler.create(logger);
        }
        return NullProfiler.NULL_INSTANCE;
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isTraceEnabled();

    public abstract Profiler start();

    public abstract Profiler startTrace(String var1);

    public abstract Profiler startTrace(String var1, Object ... var2);

    public abstract Profiler startDebug(String var1);

    public abstract Profiler startDebug(String var1, Object ... var2);

    public abstract Profiler startInfo(String var1);

    public abstract Profiler startInfo(String var1, Object ... var2);

    public abstract long stopTrace();

    public abstract long stopDebug();

    public abstract long stopInfo();

    public abstract long stopTrace(String var1);

    public abstract long stopTrace(String var1, Object ... var2);

    public abstract long stopDebug(String var1);

    public abstract long stopDebug(String var1, Object ... var2);

    public abstract long stopInfo(String var1);

    public abstract long stopInfo(String var1, Object ... var2);

    public abstract long stopError(String var1, Object ... var2);

    public abstract Profiler addContext(String var1, @Nullable Object var2);

    public abstract boolean hasContext(String var1);

    public abstract Profiler logTimeLast(boolean var1);
}

