/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.core.documentation.DocumentationLinkGenerator;

public class RuntimeJavaVersion {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeJavaVersion.class);
    public static final String LOG_MESSAGE = "SonarScanner will require Java 17 to run, starting in SonarQube 10.3";
    public static final String WARNING_MESSAGE_TEMPLATE = "SonarScanner will require Java 17 to run, starting in SonarQube 10.3. Please upgrade the version of Java that executes the scanner and refer to <a href=\"{}/\" target=\"_blank\">the documentation</a> if needed.";
    private final DocumentationLinkGenerator documentationLinkGenerator;
    private final AnalysisWarnings analysisWarnings;

    public RuntimeJavaVersion(DocumentationLinkGenerator documentationLinkGenerator, AnalysisWarnings analysisWarnings) {
        this.documentationLinkGenerator = documentationLinkGenerator;
        this.analysisWarnings = analysisWarnings;
    }

    public void checkJavaVersion() {
        Runtime.Version version = Runtime.version();
        if (version.compareTo(Runtime.Version.parse("17")) < 0) {
            LOG.warn(LOG_MESSAGE);
            String documentationLink = this.documentationLinkGenerator.getDocumentationLink("/analyzing-source-code/scanner-environment");
            this.analysisWarnings.addUnique(WARNING_MESSAGE_TEMPLATE.replace("{}", documentationLink));
        }
    }
}

