/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.scanner.externalissue.ExternalIssueImporter;
import org.sonar.scanner.externalissue.ReportParser;

public class ExternalIssuesImportSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalIssuesImportSensor.class);
    static final String REPORT_PATHS_PROPERTY_KEY = "sonar.externalIssuesReportPaths";
    private final Configuration config;

    public ExternalIssuesImportSensor(Configuration config) {
        this.config = config;
    }

    public static List<PropertyDefinition> properties() {
        return Collections.singletonList(PropertyDefinition.builder(REPORT_PATHS_PROPERTY_KEY).name("Issues report paths").description("List of comma-separated paths (absolute or relative) containing report with issues created by external rule engines.").category("externalIssues").onQualifiers("TRK", new String[0]).build());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Import external issues report").onlyWhenConfiguration(c -> c.hasKey(REPORT_PATHS_PROPERTY_KEY));
    }

    @Override
    public void execute(SensorContext context) {
        Set<String> reportPaths = this.loadReportPaths();
        for (String reportPath : reportPaths) {
            LOG.debug("Importing issues from '{}'", (Object)reportPath);
            Path reportFilePath = context.fileSystem().resolvePath(reportPath).toPath();
            ReportParser parser = new ReportParser(reportFilePath);
            ReportParser.Report report = parser.parse();
            ExternalIssueImporter issueImporter = new ExternalIssueImporter(context, report);
            issueImporter.execute();
        }
    }

    private Set<String> loadReportPaths() {
        return Arrays.stream(this.config.getStringArray(REPORT_PATHS_PROPERTY_KEY)).collect(Collectors.toSet());
    }
}

