/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.MessageException;
import org.sonar.core.sarif.Sarif210;
import org.sonar.core.sarif.SarifSerializer;
import org.sonar.scanner.externalissue.sarif.Sarif210Importer;
import org.sonar.scanner.externalissue.sarif.SarifImportResults;

@ScannerSide
public class SarifIssuesImportSensor
implements ProjectSensor {
    private static final Logger LOG = LoggerFactory.getLogger(SarifIssuesImportSensor.class);
    static final String SARIF_REPORT_PATHS_PROPERTY_KEY = "sonar.sarifReportPaths";
    private final SarifSerializer sarifSerializer;
    private final Sarif210Importer sarifImporter;
    private final Configuration config;

    public SarifIssuesImportSensor(SarifSerializer sarifSerializer, Sarif210Importer sarifImporter, Configuration config) {
        this.sarifSerializer = sarifSerializer;
        this.sarifImporter = sarifImporter;
        this.config = config;
    }

    public static List<PropertyDefinition> properties() {
        return Collections.singletonList(PropertyDefinition.builder(SARIF_REPORT_PATHS_PROPERTY_KEY).name("SARIF report paths").description("List of comma-separated paths (absolute or relative) containing a SARIF report with issues created by external rule engines.").category("externalIssues").onQualifiers("TRK", new String[0]).build());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Import external issues report from SARIF file.").onlyWhenConfiguration(c -> c.hasKey(SARIF_REPORT_PATHS_PROPERTY_KEY));
    }

    @Override
    public void execute(SensorContext context) {
        Set<String> reportPaths = this.loadReportPaths();
        HashMap<String, SarifImportResults> filePathToImportResults = new HashMap<String, SarifImportResults>();
        for (String reportPath : reportPaths) {
            try {
                SarifImportResults sarifImportResults = this.processReport(context, reportPath);
                filePathToImportResults.put(reportPath, sarifImportResults);
            }
            catch (NoSuchFileException e) {
                throw MessageException.of(String.format("SARIF report file not found: %s", e.getFile()));
            }
            catch (Exception exception) {
                LOG.warn("Failed to process SARIF report from file '{}', error: '{}'", (Object)reportPath, (Object)exception.getMessage());
            }
        }
        filePathToImportResults.forEach(SarifIssuesImportSensor::displayResults);
    }

    private Set<String> loadReportPaths() {
        return Arrays.stream(this.config.getStringArray(SARIF_REPORT_PATHS_PROPERTY_KEY)).collect(Collectors.toSet());
    }

    private SarifImportResults processReport(SensorContext context, String reportPath) throws NoSuchFileException {
        LOG.debug("Importing SARIF issues from '{}'", (Object)reportPath);
        Path reportFilePath = context.fileSystem().resolvePath(reportPath).toPath();
        Sarif210 sarifReport = this.sarifSerializer.deserialize(reportFilePath);
        return this.sarifImporter.importSarif(sarifReport);
    }

    private static void displayResults(String filePath, SarifImportResults sarifImportResults) {
        if (sarifImportResults.getFailedRuns() > 0 && sarifImportResults.getSuccessFullyImportedRuns() > 0) {
            LOG.warn("File {}: {} run(s) could not be imported (see warning above) and {} run(s) successfully imported ({} vulnerabilities in total).", filePath, sarifImportResults.getFailedRuns(), sarifImportResults.getSuccessFullyImportedRuns(), sarifImportResults.getSuccessFullyImportedIssues());
        } else if (sarifImportResults.getFailedRuns() > 0) {
            LOG.warn("File {}: {} run(s) could not be imported (see warning above).", (Object)filePath, (Object)sarifImportResults.getFailedRuns());
        } else {
            LOG.info("File {}: {} run(s) successfully imported ({} vulnerabilities in total).", filePath, sarifImportResults.getSuccessFullyImportedRuns(), sarifImportResults.getSuccessFullyImportedIssues());
        }
    }
}

