/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.genericcoverage;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.genericcoverage.GenericTestExecutionReportParser;

public class GenericTestExecutionSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(GenericTestExecutionSensor.class);
    static final String REPORT_PATHS_PROPERTY_KEY = "sonar.testExecutionReportPaths";
    @Deprecated
    static final String OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY = "sonar.genericcoverage.unitTestReportPaths";
    private final TestPlanBuilder testPlanBuilder;
    private final DefaultConfiguration configuration;

    public GenericTestExecutionSensor(TestPlanBuilder testPlanBuilder, DefaultConfiguration configuration) {
        this.testPlanBuilder = testPlanBuilder;
        this.configuration = configuration;
    }

    public static List<PropertyDefinition> properties() {
        return Collections.singletonList(PropertyDefinition.builder(REPORT_PATHS_PROPERTY_KEY).name("Unit tests results report paths").description("List of comma-separated paths (absolute or relative) containing unit tests results report.").category("codeCoverage").onQualifiers("TRK", new String[0]).multiValues(true).deprecatedKey(OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY).build());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Generic Test Executions Report").global().onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PATHS_PROPERTY_KEY));
    }

    @Override
    public void execute(SensorContext context) {
        if (this.configuration.getOriginalProperties().containsKey(OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY)) {
            LOG.warn("Property '{}' is deprecated. Please use '{}' instead.", (Object)OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY, (Object)REPORT_PATHS_PROPERTY_KEY);
        }
        for (String reportPath : this.configuration.getStringArray(REPORT_PATHS_PROPERTY_KEY)) {
            File reportFile = context.fileSystem().resolvePath(reportPath);
            LOG.info("Parsing {}", (Object)reportFile);
            GenericTestExecutionReportParser parser = new GenericTestExecutionReportParser(this.testPlanBuilder);
            parser.parse(reportFile, context);
            LOG.info("Imported test execution data for {} files", (Object)parser.numberOfMatchedFiles());
            int numberOfUnknownFiles = parser.numberOfUnknownFiles();
            if (numberOfUnknownFiles <= 0) continue;
            LOG.info("Test execution data ignored for {} unknown files, including:\n{}", (Object)numberOfUnknownFiles, (Object)parser.firstUnknownFiles().stream().collect(Collectors.joining("\n")));
        }
    }
}

