/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.internal.DefaultActiveRules;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.scanner.issue.DefaultFilterableIssue;
import org.sonar.scanner.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;

@ThreadSafe
public class EnforceIssuesFilter
implements IssueFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EnforceIssuesFilter.class);
    private final List<IssuePattern> multicriteriaPatterns;
    private final AnalysisWarnings analysisWarnings;
    private final DefaultActiveRules activeRules;
    private final Set<RuleKey> warnedDeprecatedRuleKeys = new LinkedHashSet<RuleKey>();
    private boolean warnDeprecatedIssuePatternAlreadyLogged;

    public EnforceIssuesFilter(IssueInclusionPatternInitializer patternInitializer, AnalysisWarnings analysisWarnings, DefaultActiveRules activeRules) {
        this.multicriteriaPatterns = List.copyOf(patternInitializer.getMulticriteriaPatterns());
        this.analysisWarnings = analysisWarnings;
        this.activeRules = activeRules;
    }

    @Override
    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        boolean atLeastOneRuleMatched = false;
        boolean atLeastOnePatternFullyMatched = false;
        IssuePattern matchingPattern = null;
        for (IssuePattern pattern : this.multicriteriaPatterns) {
            if (!this.ruleMatches(pattern, issue.ruleKey())) continue;
            atLeastOneRuleMatched = true;
            InputComponent component = ((DefaultFilterableIssue)issue).getComponent();
            if (!component.isFile()) continue;
            DefaultInputFile file = (DefaultInputFile)component;
            if (pattern.matchFile(file.getProjectRelativePath())) {
                atLeastOnePatternFullyMatched = true;
                matchingPattern = pattern;
                continue;
            }
            if (!pattern.matchFile(file.getModuleRelativePath())) continue;
            this.warnOnceDeprecatedIssuePattern("Specifying module-relative paths at project level in property 'sonar.issue.enforce.multicriteria' is deprecated. To continue matching files like '" + file.getProjectRelativePath() + "', update this property so that patterns refer to project-relative paths.");
            atLeastOnePatternFullyMatched = true;
            matchingPattern = pattern;
        }
        if (atLeastOneRuleMatched) {
            if (atLeastOnePatternFullyMatched) {
                LOG.debug("Issue '{}' enforced by pattern '{}'", (Object)issue, (Object)matchingPattern);
            }
            return atLeastOnePatternFullyMatched;
        }
        return chain.accept(issue);
    }

    private boolean ruleMatches(IssuePattern pattern, RuleKey ruleKey) {
        if (this.activeRules.matchesDeprecatedKeys(ruleKey, pattern.getRulePattern())) {
            String msg = String.format("A multicriteria issue enforce uses the rule key '%s' that has been changed. The pattern should be updated to '%s'", pattern.getRulePattern(), ruleKey);
            this.analysisWarnings.addUnique(msg);
            if (this.warnedDeprecatedRuleKeys.add(ruleKey)) {
                LOG.warn(msg);
            }
            return true;
        }
        return pattern.matchRule(ruleKey);
    }

    private void warnOnceDeprecatedIssuePattern(String msg) {
        if (!this.warnDeprecatedIssuePatternAlreadyLogged) {
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
            this.warnDeprecatedIssuePatternAlreadyLogged = true;
        }
    }
}

