/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.scanner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.scanner.issue.ignore.pattern.LineRange;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;

public class IssueExclusionsRegexpScanner
extends CharHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IssueExclusionsRegexpScanner.class);
    private final StringBuilder sb = new StringBuilder();
    private final List<Pattern> allFilePatterns;
    private final List<IssueExclusionsLoader.DoubleRegexpMatcher> blockMatchers;
    private final DefaultInputFile inputFile;
    private int lineIndex = 1;
    private List<LineExclusion> lineExclusions = new ArrayList<LineExclusion>();
    private LineExclusion currentLineExclusion = null;
    private int fileLength = 0;
    private IssueExclusionsLoader.DoubleRegexpMatcher currentMatcher;
    private boolean ignoreAllIssues;

    IssueExclusionsRegexpScanner(DefaultInputFile inputFile, List<Pattern> allFilePatterns, List<IssueExclusionsLoader.DoubleRegexpMatcher> blockMatchers) {
        this.allFilePatterns = allFilePatterns;
        this.blockMatchers = blockMatchers;
        this.inputFile = inputFile;
        LOG.debug("Evaluate issue exclusions for '{}'", (Object)inputFile.getProjectRelativePath());
    }

    @Override
    public void handleIgnoreEoL(char c) {
        if (this.ignoreAllIssues) {
            return;
        }
        this.sb.append(c);
    }

    @Override
    public void newLine() {
        if (this.ignoreAllIssues) {
            return;
        }
        this.processLine(this.sb.toString());
        this.sb.setLength(0);
        ++this.lineIndex;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void eof() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processLine(String line) {
        if (line.trim().length() == 0) {
            return;
        }
        for (Pattern pattern : this.allFilePatterns) {
            if (!pattern.matcher(line).find()) continue;
            LOG.debug("  - Exclusion pattern '{}': all issues in this file will be ignored.", (Object)pattern);
            this.ignoreAllIssues = true;
            this.inputFile.setIgnoreAllIssues(true);
            return;
        }
        this.checkDoubleRegexps(line, this.lineIndex);
    }

    private Set<LineRange> convertLineExclusionsToLineRanges() {
        HashSet<LineRange> lineRanges = new HashSet<LineRange>(this.lineExclusions.size());
        for (LineExclusion lineExclusion : this.lineExclusions) {
            lineRanges.add(lineExclusion.toLineRange(this.fileLength));
        }
        return lineRanges;
    }

    private void checkDoubleRegexps(String line, int lineIndex) {
        if (this.currentMatcher == null) {
            for (IssueExclusionsLoader.DoubleRegexpMatcher matcher : this.blockMatchers) {
                if (!matcher.matchesFirstPattern(line)) continue;
                this.startExclusion(lineIndex);
                this.currentMatcher = matcher;
                break;
            }
        } else if (this.currentMatcher.matchesSecondPattern(line)) {
            this.endExclusion(lineIndex);
            this.currentMatcher = null;
        }
    }

    private void startExclusion(int lineIndex) {
        this.currentLineExclusion = new LineExclusion(lineIndex);
        this.lineExclusions.add(this.currentLineExclusion);
    }

    private void endExclusion(int lineIndex) {
        this.currentLineExclusion.setEnd(lineIndex);
        this.currentLineExclusion = null;
    }

    private static class LineExclusion {
        private int start;
        private int end;

        LineExclusion(int start) {
            this.start = start;
            this.end = -1;
        }

        void setEnd(int end) {
            this.end = end;
        }

        public LineRange toLineRange(int fileLength) {
            return new LineRange(this.start, this.end == -1 ? fileLength : this.end);
        }
    }
}

