/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.platform;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.platform.SonarQubeVersion;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;

public class DefaultServer
extends Server {
    private final Configuration settings;
    private final DefaultScannerWsClient client;
    private final SonarQubeVersion sonarQubeVersion;

    public DefaultServer(Configuration settings, DefaultScannerWsClient client, SonarQubeVersion sonarQubeVersion) {
        this.settings = settings;
        this.client = client;
        this.sonarQubeVersion = sonarQubeVersion;
    }

    @Override
    public String getId() {
        return this.settings.get("sonar.core.id").orElseThrow(() -> new IllegalStateException("Mandatory"));
    }

    @Override
    public String getVersion() {
        return this.sonarQubeVersion.get().toString();
    }

    @Override
    public Date getStartedAt() {
        String dateString = this.settings.get("sonar.core.startTime").orElseThrow(() -> new IllegalStateException("Mandatory"));
        return DateUtils.parseDateTime(dateString);
    }

    @Override
    public String getContextPath() {
        return null;
    }

    @Override
    public String getPublicRootUrl() {
        String baseUrl = StringUtils.trimToEmpty(this.settings.get("sonar.core.serverBaseURL").orElse(""));
        if (baseUrl.isEmpty()) {
            baseUrl = this.client.baseUrl();
        }
        return StringUtils.removeEnd(baseUrl, "/");
    }
}

