/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.qualitygate;

import java.io.InputStream;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Startable;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.report.CeTaskReportDataHolder;
import org.sonar.scanner.scan.ScanProperties;
import org.sonarqube.ws.Ce;
import org.sonarqube.ws.Qualitygates;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.RequestWithoutPayload;
import org.sonarqube.ws.client.WsResponse;

public class QualityGateCheck
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(QualityGateCheck.class);
    private static final EnumSet<Ce.TaskStatus> TASK_TERMINAL_STATUSES = EnumSet.of(Ce.TaskStatus.SUCCESS, Ce.TaskStatus.FAILED, Ce.TaskStatus.CANCELED);
    private static final int POLLING_INTERVAL_IN_MS = 5000;
    private final DefaultScannerWsClient wsClient;
    private final GlobalAnalysisMode analysisMode;
    private final CeTaskReportDataHolder ceTaskReportDataHolder;
    private final ScanProperties properties;
    private long qualityGateTimeoutInMs;
    private boolean enabled;

    public QualityGateCheck(DefaultScannerWsClient wsClient, GlobalAnalysisMode analysisMode, CeTaskReportDataHolder ceTaskReportDataHolder, ScanProperties properties) {
        this.wsClient = wsClient;
        this.properties = properties;
        this.ceTaskReportDataHolder = ceTaskReportDataHolder;
        this.analysisMode = analysisMode;
    }

    @Override
    public void start() {
        this.enabled = this.properties.shouldWaitForQualityGate();
        this.qualityGateTimeoutInMs = Duration.of(this.properties.qualityGateWaitTimeout(), ChronoUnit.SECONDS).toMillis();
    }

    @Override
    public void stop() {
    }

    public void await() {
        if (!this.enabled) {
            LOG.debug("Quality Gate check disabled - skipping");
            return;
        }
        if (this.analysisMode.isMediumTest()) {
            throw new IllegalStateException("Quality Gate check not available in medium test mode");
        }
        LOG.info("Waiting for the analysis report to be processed (max {}s)", (Object)this.properties.qualityGateWaitTimeout());
        String taskId = this.ceTaskReportDataHolder.getCeTaskId();
        Ce.Task task = this.waitForCeTaskToFinish(taskId);
        if (!Ce.TaskStatus.SUCCESS.equals(task.getStatus())) {
            throw MessageException.of(String.format("CE Task finished abnormally with status: %s, you can check details here: %s", task.getStatus().name(), this.ceTaskReportDataHolder.getCeTaskUrl()));
        }
        Qualitygates.ProjectStatusResponse.Status qualityGateStatus = this.getQualityGateStatus(task.getAnalysisId());
        if (!Qualitygates.ProjectStatusResponse.Status.OK.equals(qualityGateStatus)) {
            throw MessageException.of("QUALITY GATE STATUS: FAILED - View details on " + this.ceTaskReportDataHolder.getDashboardUrl());
        }
        LOG.info("QUALITY GATE STATUS: PASSED - View details on " + this.ceTaskReportDataHolder.getDashboardUrl());
    }

    private Ce.Task waitForCeTaskToFinish(String taskId) {
        GetRequest getTaskResultReq = (GetRequest)((RequestWithoutPayload)new GetRequest("api/ce/task").setMediaType("application/x-protobuf")).setParam("id", taskId);
        for (long currentTime = 0L; this.qualityGateTimeoutInMs > currentTime; currentTime += 5000L) {
            try {
                WsResponse getTaskResultResponse = this.wsClient.call(getTaskResultReq).failIfNotSuccessful();
                Ce.Task task = QualityGateCheck.parseCeTaskResponse(getTaskResultResponse);
                if (TASK_TERMINAL_STATUSES.contains(task.getStatus())) {
                    return task;
                }
                Thread.sleep(5000L);
                continue;
            }
            catch (HttpException e) {
                throw MessageException.of(String.format("Failed to get CE Task status - %s", DefaultScannerWsClient.createErrorMessage(e)));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Quality Gate check has been interrupted", e);
            }
        }
        throw MessageException.of("Quality Gate check timeout exceeded - View details on " + this.ceTaskReportDataHolder.getDashboardUrl());
    }

    private static Ce.Task parseCeTaskResponse(WsResponse response) {
        Ce.Task task;
        block8: {
            InputStream protobuf = response.contentStream();
            try {
                task = Ce.TaskResponse.parser().parseFrom(protobuf).getTask();
                if (protobuf == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (protobuf != null) {
                        try {
                            protobuf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to parse response from " + response.requestUrl(), e);
                }
            }
            protobuf.close();
        }
        return task;
    }

    private Qualitygates.ProjectStatusResponse.Status getQualityGateStatus(String analysisId) {
        GetRequest getQualityGateReq = (GetRequest)((RequestWithoutPayload)new GetRequest("api/qualitygates/project_status").setMediaType("application/x-protobuf")).setParam("analysisId", analysisId);
        try {
            WsResponse getTaskResultResponse = this.wsClient.call(getQualityGateReq).failIfNotSuccessful();
            Qualitygates.ProjectStatusResponse.ProjectStatus status = QualityGateCheck.parseQualityGateResponse(getTaskResultResponse);
            return status.getStatus();
        }
        catch (HttpException e) {
            throw MessageException.of(String.format("Failed to get Quality Gate status - %s", DefaultScannerWsClient.createErrorMessage(e)));
        }
    }

    private static Qualitygates.ProjectStatusResponse.ProjectStatus parseQualityGateResponse(WsResponse response) {
        Qualitygates.ProjectStatusResponse.ProjectStatus projectStatus;
        block8: {
            InputStream protobuf = response.contentStream();
            try {
                projectStatus = Qualitygates.ProjectStatusResponse.parser().parseFrom(protobuf).getProjectStatus();
                if (protobuf == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (protobuf != null) {
                        try {
                            protobuf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to parse response from " + response.requestUrl(), e);
                }
            }
            protobuf.close();
        }
        return projectStatus;
    }
}

