/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.scanner.scan.ProjectBuildersExecutor;
import org.sonar.scanner.scan.ProjectReactorValidator;
import org.sonar.scanner.scan.WorkDirectoriesInitializer;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;
import org.springframework.context.annotation.Bean;

public class InputProjectProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InputProjectProvider.class);

    @Bean(value={"DefaultInputProject"})
    public DefaultInputProject provide(ProjectBuildersExecutor projectBuildersExecutor, ProjectReactorValidator validator, ProjectReactor projectReactor, ScannerComponentIdGenerator scannerComponentIdGenerator, WorkDirectoriesInitializer workDirectoriesInit) {
        projectBuildersExecutor.execute(projectReactor);
        validator.validate(projectReactor);
        DefaultInputProject project = new DefaultInputProject(projectReactor.getRoot(), scannerComponentIdGenerator.getAsInt());
        workDirectoriesInit.execute(project);
        LOG.info("Project key: {}", (Object)project.key());
        LOG.info("Base dir: {}", (Object)project.getBaseDir().toAbsolutePath().toString());
        LOG.info("Working dir: {}", (Object)project.getWorkDir().toAbsolutePath().toString());
        LOG.debug("Project global encoding: {}, default locale: {}", (Object)project.getEncoding().displayName(), (Object)Locale.getDefault());
        return project;
    }
}

