/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchType;
import org.sonar.scanner.scan.filesystem.MutableFileSystem;
import org.sonar.scanner.sensor.AbstractSensorOptimizer;

public abstract class AbstractSensorWrapper<G extends ProjectSensor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSensorWrapper.class);
    private final G wrappedSensor;
    private final SensorContext context;
    private final MutableFileSystem fileSystem;
    private final DefaultSensorDescriptor descriptor;
    private final AbstractSensorOptimizer optimizer;
    private final boolean isPullRequest;

    public AbstractSensorWrapper(G sensor, SensorContext context, AbstractSensorOptimizer optimizer, MutableFileSystem fileSystem, BranchConfiguration branchConfiguration) {
        this.wrappedSensor = sensor;
        this.optimizer = optimizer;
        this.context = context;
        this.descriptor = new DefaultSensorDescriptor();
        this.fileSystem = fileSystem;
        this.isPullRequest = branchConfiguration.branchType() == BranchType.PULL_REQUEST;
        sensor.describe(this.descriptor);
        if (this.descriptor.name() == null) {
            this.descriptor.name(sensor.getClass().getName());
        }
    }

    public boolean shouldExecute() {
        return this.optimizer.shouldExecute(this.descriptor);
    }

    public void analyse() {
        boolean sensorIsRestricted;
        boolean bl = sensorIsRestricted = this.descriptor.isProcessesFilesIndependently() && this.isPullRequest;
        if (sensorIsRestricted) {
            LOGGER.info("Sensor {} is restricted to changed files only", (Object)this.descriptor.name());
        }
        this.fileSystem.setRestrictToChangedFiles(sensorIsRestricted);
        this.wrappedSensor.execute(this.context);
    }

    public G wrappedSensor() {
        return this.wrappedSensor;
    }

    public String toString() {
        return this.descriptor.name();
    }

    public boolean isGlobal() {
        return this.descriptor.isGlobal();
    }
}

