/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.System2;
import org.sonar.core.documentation.DocumentationLinkGenerator;
import org.sonar.scm.git.ChangedFile;
import org.sonar.scm.git.ChangedLinesComputer;
import org.sonar.scm.git.CompositeBlameCommand;
import org.sonar.scm.git.GitIgnoreCommand;

public class GitScmProvider
extends ScmProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GitScmProvider.class);
    private static final String COULD_NOT_FIND_REF = "Could not find ref '%s' in refs/heads, refs/remotes, refs/remotes/upstream or refs/remotes/origin";
    private static final String NO_MERGE_BASE_FOUND_MESSAGE = "No merge base found between HEAD and %s";
    @VisibleForTesting
    static final String SCM_INTEGRATION_DOCUMENTATION_SUFFIX = "/analyzing-source-code/scm-integration/";
    private final BlameCommand blameCommand;
    private final AnalysisWarnings analysisWarnings;
    private final GitIgnoreCommand gitIgnoreCommand;
    private final System2 system2;
    private final DocumentationLinkGenerator documentationLinkGenerator;

    public GitScmProvider(CompositeBlameCommand blameCommand, AnalysisWarnings analysisWarnings, GitIgnoreCommand gitIgnoreCommand, System2 system2, DocumentationLinkGenerator documentationLinkGenerator) {
        this.blameCommand = blameCommand;
        this.analysisWarnings = analysisWarnings;
        this.gitIgnoreCommand = gitIgnoreCommand;
        this.system2 = system2;
        this.documentationLinkGenerator = documentationLinkGenerator;
    }

    @Override
    public GitIgnoreCommand ignoreCommand() {
        return this.gitIgnoreCommand;
    }

    @Override
    public String key() {
        return "git";
    }

    @Override
    public boolean supports(File baseDir) {
        RepositoryBuilder builder = (RepositoryBuilder)new RepositoryBuilder().findGitDir(baseDir);
        return builder.getGitDir() != null;
    }

    @Override
    public BlameCommand blameCommand() {
        return this.blameCommand;
    }

    @Override
    @CheckForNull
    public Set<Path> branchChangedFiles(String targetBranchName, Path rootBaseDir) {
        return Optional.ofNullable(this.branchChangedFilesWithFileMovementDetection(targetBranchName, rootBaseDir)).map(GitScmProvider::extractAbsoluteFilePaths).orElse(null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public Set<ChangedFile> branchChangedFilesWithFileMovementDetection(String targetBranchName, Path rootBaseDir) {
        try (Repository repo = this.buildRepo(rootBaseDir);){
            Ref targetRef = this.resolveTargetRef(targetBranchName, repo);
            if (targetRef == null) {
                this.addWarningTargetNotFound(targetBranchName);
                Set<ChangedFile> set = null;
                return set;
            }
            if (GitScmProvider.isDiffAlgoInvalid(repo.getConfig())) {
                LOG.warn("The diff algorithm configured in git is not supported. No information regarding changes in the branch will be collected, which can lead to unexpected results.");
                Set<ChangedFile> set = null;
                return set;
            }
            Optional<RevCommit> mergeBaseCommit = GitScmProvider.findMergeBase(repo, targetRef);
            if (mergeBaseCommit.isEmpty()) {
                LOG.warn(GitScmProvider.composeNoMergeBaseFoundWarning(targetRef.getName()));
                Set<ChangedFile> set = null;
                return set;
            }
            AbstractTreeIterator mergeBaseTree = this.prepareTreeParser(repo, mergeBaseCommit.get());
            Git git = this.newGit(repo);
            try {
                Object diffEntries = git.diff().setShowNameAndStatusOnly(true).setOldTree(mergeBaseTree).setNewTree(GitScmProvider.prepareNewTree(repo)).call();
                Set<ChangedFile> set = GitScmProvider.computeChangedFiles(repo, (List<DiffEntry>)diffEntries);
                if (git != null) {
                    git.close();
                }
                return set;
            }
            catch (Throwable throwable) {
                if (git != null) {
                    try {
                        git.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            LOG.warn(e.getMessage(), e);
            return null;
        }
    }

    private static Set<ChangedFile> computeChangedFiles(Repository repository, List<DiffEntry> diffEntries) throws IOException {
        Path workingDirectory = repository.getWorkTree().toPath();
        Map<String, String> renamedFilePaths = GitScmProvider.computeRenamedFilePaths(repository, diffEntries);
        Set<String> changedFilePaths = GitScmProvider.computeChangedFilePaths(diffEntries);
        return GitScmProvider.collectChangedFiles(workingDirectory, renamedFilePaths, changedFilePaths);
    }

    private static Set<ChangedFile> collectChangedFiles(Path workingDirectory, Map<String, String> renamedFilePaths, Set<String> changedFilePaths) {
        HashSet<ChangedFile> changedFiles = new HashSet<ChangedFile>();
        changedFilePaths.forEach(filePath -> changedFiles.add(ChangedFile.of(workingDirectory.resolve((String)filePath), (String)renamedFilePaths.get(filePath))));
        return changedFiles;
    }

    private static Map<String, String> computeRenamedFilePaths(Repository repository, List<DiffEntry> diffEntries) throws IOException {
        RenameDetector renameDetector = new RenameDetector(repository);
        renameDetector.addAll(diffEntries);
        return renameDetector.compute().stream().filter(entry -> DiffEntry.ChangeType.RENAME.equals((Object)entry.getChangeType())).collect(Collectors.toUnmodifiableMap(DiffEntry::getNewPath, DiffEntry::getOldPath));
    }

    private static Set<String> computeChangedFilePaths(List<DiffEntry> diffEntries) {
        return diffEntries.stream().filter(GitScmProvider.isAllowedChangeType(DiffEntry.ChangeType.ADD, DiffEntry.ChangeType.MODIFY)).map(DiffEntry::getNewPath).collect(Collectors.toSet());
    }

    private static Predicate<DiffEntry> isAllowedChangeType(DiffEntry.ChangeType ... changeTypes) {
        Function<DiffEntry.ChangeType, Predicate> isChangeType = type -> entry -> type.equals((Object)entry.getChangeType());
        return Arrays.stream(changeTypes).map(isChangeType).reduce(x -> false, Predicate::or);
    }

    @Override
    @CheckForNull
    public Map<Path, Set<Integer>> branchChangedLines(String targetBranchName, Path projectBaseDir, Set<Path> changedFiles) {
        return this.branchChangedLinesWithFileMovementDetection(targetBranchName, projectBaseDir, GitScmProvider.toChangedFileByPathsMap(changedFiles));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public Map<Path, Set<Integer>> branchChangedLinesWithFileMovementDetection(String targetBranchName, Path projectBaseDir, Map<Path, ChangedFile> changedFiles) {
        try (Repository repo = this.buildRepo(projectBaseDir);){
            Ref targetRef = this.resolveTargetRef(targetBranchName, repo);
            if (targetRef == null) {
                this.addWarningTargetNotFound(targetBranchName);
                Map<Path, Set<Integer>> map = null;
                return map;
            }
            if (GitScmProvider.isDiffAlgoInvalid(repo.getConfig())) {
                Map<Path, Set<Integer>> map = null;
                return map;
            }
            repo.getConfig().setBoolean("core", null, "autocrlf", true);
            Optional<RevCommit> mergeBaseCommit = GitScmProvider.findMergeBase(repo, targetRef);
            if (mergeBaseCommit.isEmpty()) {
                LOG.warn(GitScmProvider.composeNoMergeBaseFoundWarning(targetRef.getName()));
                Map<Path, Set<Integer>> map = null;
                return map;
            }
            HashMap<Path, Set<Integer>> changedLines = new HashMap<Path, Set<Integer>>();
            for (Map.Entry<Path, ChangedFile> entry : changedFiles.entrySet()) {
                this.collectChangedLines(repo, mergeBaseCommit.get(), changedLines, entry.getKey(), entry.getValue());
            }
            HashMap<Path, Set<Integer>> hashMap = changedLines;
            return hashMap;
        }
        catch (Exception e) {
            LOG.warn("Failed to get changed lines from git", e);
            return null;
        }
    }

    private static String composeNoMergeBaseFoundWarning(String targetRef) {
        return String.format(NO_MERGE_BASE_FOUND_MESSAGE, targetRef);
    }

    private void addWarningTargetNotFound(String targetBranchName) {
        String url = this.documentationLinkGenerator.getDocumentationLink(SCM_INTEGRATION_DOCUMENTATION_SUFFIX);
        this.analysisWarnings.addUnique(String.format("Could not find ref '%s' in refs/heads, refs/remotes, refs/remotes/upstream or refs/remotes/origin. You may see unexpected issues and changes. Please make sure to fetch this ref before pull request analysis and refer to <a href=\"%s\" rel=\"noopener noreferrer\" target=\"_blank\">the documentation</a>.", targetBranchName, url));
    }

    private void collectChangedLines(Repository repo, RevCommit mergeBaseCommit, Map<Path, Set<Integer>> changedLines, Path changedFilePath, ChangedFile changedFile) {
        ChangedLinesComputer computer = new ChangedLinesComputer();
        try (DiffFormatter diffFmt = new DiffFormatter(new BufferedOutputStream(computer.receiver()));){
            diffFmt.setRepository(repo);
            diffFmt.setProgressMonitor(NullProgressMonitor.INSTANCE);
            diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_ALL);
            diffFmt.setDetectRenames(changedFile.isMovedFile());
            Path workTree = repo.getWorkTree().toPath();
            TreeFilter treeFilter = GitScmProvider.getTreeFilter(changedFile, workTree);
            diffFmt.setPathFilter(treeFilter);
            AbstractTreeIterator mergeBaseTree = this.prepareTreeParser(repo, mergeBaseCommit);
            List<DiffEntry> diffEntries = diffFmt.scan(mergeBaseTree, new FileTreeIterator(repo));
            diffFmt.format(diffEntries);
            diffFmt.flush();
            diffEntries.stream().filter(GitScmProvider.isAllowedChangeType(DiffEntry.ChangeType.ADD, DiffEntry.ChangeType.MODIFY, DiffEntry.ChangeType.RENAME)).findAny().ifPresent(diffEntry -> changedLines.put(changedFilePath, computer.changedLines()));
        }
        catch (Exception e) {
            LOG.warn("Failed to get changed lines from git for file " + changedFilePath, e);
        }
    }

    @Override
    @CheckForNull
    public Instant forkDate(String referenceBranchName, Path projectBaseDir) {
        return null;
    }

    private static String toGitPath(String path) {
        return path.replaceAll(Pattern.quote(File.separator), "/");
    }

    private static TreeFilter getTreeFilter(ChangedFile changedFile, Path baseDir) {
        String path = GitScmProvider.toGitPath(GitScmProvider.relativizeFilePath(baseDir, changedFile.getAbsolutFilePath()));
        String oldRelativePath = changedFile.getOldRelativeFilePathReference();
        if (oldRelativePath != null) {
            return PathFilterGroup.createFromStrings(path, GitScmProvider.toGitPath(oldRelativePath));
        }
        return PathFilter.create(path);
    }

    private static Set<Path> extractAbsoluteFilePaths(Collection<ChangedFile> changedFiles) {
        return changedFiles.stream().map(ChangedFile::getAbsolutFilePath).collect(Collectors.toSet());
    }

    @CheckForNull
    private Ref resolveTargetRef(String targetBranchName, Repository repo) throws IOException {
        String localRef = "refs/heads/" + targetBranchName;
        String remotesRef = "refs/remotes/" + targetBranchName;
        String originRef = "refs/remotes/origin/" + targetBranchName;
        String upstreamRef = "refs/remotes/upstream/" + targetBranchName;
        Ref targetRef = this.runningOnCircleCI() ? GitScmProvider.getFirstExistingRef(repo, originRef, localRef, upstreamRef, remotesRef) : GitScmProvider.getFirstExistingRef(repo, localRef, originRef, upstreamRef, remotesRef);
        if (targetRef == null) {
            LOG.warn(String.format(COULD_NOT_FIND_REF, targetBranchName));
        }
        return targetRef;
    }

    @CheckForNull
    private static Ref getFirstExistingRef(Repository repo, String ... refs) throws IOException {
        String ref;
        Ref targetRef = null;
        String[] stringArray = refs;
        int n = stringArray.length;
        for (int i = 0; i < n && (targetRef = repo.exactRef(ref = stringArray[i])) == null; ++i) {
        }
        return targetRef;
    }

    private boolean runningOnCircleCI() {
        return "true".equals(this.system2.envVariable("CIRCLECI"));
    }

    @Override
    public Path relativePathFromScmRoot(Path path) {
        RepositoryBuilder builder = GitScmProvider.getVerifiedRepositoryBuilder(path);
        return builder.getGitDir().toPath().getParent().relativize(path);
    }

    @Override
    @CheckForNull
    public String revisionId(Path path) {
        RepositoryBuilder builder = GitScmProvider.getVerifiedRepositoryBuilder(path);
        try {
            return Optional.ofNullable(GitScmProvider.getHead(builder.build())).map(Ref::getObjectId).map(AnyObjectId::getName).orElse(null);
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error while getting revision ID for path: " + path, e);
        }
    }

    private static boolean isDiffAlgoInvalid(Config cfg) {
        try {
            DiffAlgorithm.getAlgorithm(cfg.getEnum("diff", null, "algorithm", DiffAlgorithm.SupportedAlgorithm.HISTOGRAM));
            return false;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    private static AbstractTreeIterator prepareNewTree(Repository repo) throws IOException {
        CanonicalTreeParser treeParser = new CanonicalTreeParser();
        try (ObjectReader objectReader = repo.newObjectReader();){
            Ref head = GitScmProvider.getHead(repo);
            if (head == null) {
                throw new IOException("HEAD reference not found");
            }
            treeParser.reset(objectReader, repo.parseCommit(head.getObjectId()).getTree());
        }
        return treeParser;
    }

    @CheckForNull
    private static Ref getHead(Repository repo) throws IOException {
        return repo.exactRef("HEAD");
    }

    private static Optional<RevCommit> findMergeBase(Repository repo, Ref targetRef) throws IOException {
        try (RevWalk walk = new RevWalk(repo);){
            Ref head = GitScmProvider.getHead(repo);
            if (head == null) {
                throw new IOException("HEAD reference not found");
            }
            walk.markStart(walk.parseCommit(targetRef.getObjectId()));
            walk.markStart(walk.parseCommit(head.getObjectId()));
            walk.setRevFilter(RevFilter.MERGE_BASE);
            RevCommit next = walk.next();
            if (next == null) {
                Optional<RevCommit> optional = Optional.empty();
                return optional;
            }
            RevCommit base = walk.parseCommit(next);
            walk.dispose();
            LOG.info("Merge base sha1: {}", (Object)base.getName());
            Optional<RevCommit> optional = Optional.of(base);
            return optional;
        }
    }

    private static Map<Path, ChangedFile> toChangedFileByPathsMap(Set<Path> changedFiles) {
        return changedFiles.stream().collect(Collectors.toMap(Function.identity(), ChangedFile::of, (x, y) -> y, LinkedHashMap::new));
    }

    private static String relativizeFilePath(Path baseDirectory, Path filePath) {
        return baseDirectory.relativize(filePath).toString();
    }

    AbstractTreeIterator prepareTreeParser(Repository repo, RevCommit commit) throws IOException {
        CanonicalTreeParser treeParser = new CanonicalTreeParser();
        try (ObjectReader objectReader = repo.newObjectReader();){
            treeParser.reset(objectReader, commit.getTree());
        }
        return treeParser;
    }

    Git newGit(Repository repo) {
        return new Git(repo);
    }

    Repository buildRepo(Path basedir) throws IOException {
        return GitScmProvider.getVerifiedRepositoryBuilder(basedir).build();
    }

    static RepositoryBuilder getVerifiedRepositoryBuilder(Path basedir) {
        RepositoryBuilder builder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().findGitDir(basedir.toFile())).setMustExist(true);
        if (builder.getGitDir() == null) {
            throw MessageException.of("Not inside a Git work tree: " + basedir);
        }
        return builder;
    }
}

