/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.sonar.scm.git.blame.FileCandidate;

public class BlobReader {
    private final Repository repository;

    public BlobReader(Repository repository) {
        this.repository = repository;
    }

    public RawText loadText(ObjectReader objectReader, FileCandidate fc) {
        try {
            if (ObjectId.zeroId().equals(fc.getBlob())) {
                return this.loadText(fc.getOriginalPath());
            }
            return BlobReader.loadText(objectReader, fc.getBlob());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static RawText loadText(ObjectReader objectReader, ObjectId objectId) throws IOException {
        ObjectLoader open = objectReader.open(objectId, 3);
        return new RawText(open.getCachedBytes(Integer.MAX_VALUE));
    }

    private RawText loadText(String path) throws IOException {
        FileTreeIterator iter;
        TreeWalk treeWalk = new TreeWalk(this.repository);
        treeWalk.addTree(new FileTreeIterator(this.repository));
        treeWalk.setRecursive(true);
        treeWalk.setFilter(PathFilter.create(path));
        if (treeWalk.next() && ((iter = treeWalk.getTree(0, FileTreeIterator.class)).getEntryRawMode() & 0xF000) == 32768) {
            try (InputStream is = iter.openEntryStream();){
                RawText rawText = new RawText(is.readAllBytes());
                return rawText;
            }
        }
        throw new IllegalStateException("Failed to find file in the working directory: " + path);
    }

    Map<String, Integer> getFileSizes(Set<String> files) throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        TreeWalk treeWalk = new TreeWalk(this.repository);
        treeWalk.addTree(new FileTreeIterator(this.repository));
        treeWalk.setRecursive(true);
        while (treeWalk.next()) {
            FileTreeIterator iter = treeWalk.getTree(0, FileTreeIterator.class);
            if (!files.contains(iter.getEntryPathString()) || (iter.getEntryRawMode() & 0xF000) != 32768) continue;
            InputStream is = iter.openEntryStream();
            try {
                RawText rawText = new RawText(is.readAllBytes());
                result.put(iter.getEntryPathString(), rawText.size());
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return result;
    }
}

