/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.svn;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.scm.svn.ChangedLinesComputer;
import org.sonar.scm.svn.SvnBlameCommand;
import org.sonar.scm.svn.SvnConfiguration;
import org.sonar.scm.svn.SvnScmSupport;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnScmProvider
extends ScmProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SvnScmProvider.class);
    private final SvnConfiguration configuration;
    private final SvnBlameCommand blameCommand;

    public SvnScmProvider(SvnConfiguration configuration, SvnBlameCommand blameCommand) {
        this.configuration = configuration;
        this.blameCommand = blameCommand;
    }

    @Override
    public String key() {
        return "svn";
    }

    @Override
    public boolean supports(File baseDir) {
        for (File folder = baseDir; folder != null; folder = folder.getParentFile()) {
            if (!new File(folder, ".svn").exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlameCommand blameCommand() {
        return this.blameCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public Set<Path> branchChangedFiles(String targetBranchName, Path rootBaseDir) {
        SVNClientManager clientManager = null;
        try {
            clientManager = SvnScmSupport.newSvnClientManager(this.configuration);
            Set<Path> set = SvnScmProvider.computeChangedPaths(rootBaseDir, clientManager);
            return set;
        }
        catch (SVNException e) {
            LOG.warn(e.getMessage());
        }
        finally {
            if (clientManager != null) {
                try {
                    clientManager.dispose();
                }
                catch (Exception e) {
                    LOG.warn("Unable to dispose SVN ClientManager", e);
                }
            }
        }
        return null;
    }

    static Set<Path> computeChangedPaths(Path projectBasedir, SVNClientManager clientManager) throws SVNException {
        SVNWCClient wcClient = clientManager.getWCClient();
        SVNInfo svnInfo = wcClient.doInfo(projectBasedir.toFile(), null);
        Path svnRootPath = SvnScmProvider.toPath(svnInfo.getRepositoryRootURL());
        if (svnRootPath.equals(Paths.get("", new String[0]))) {
            svnRootPath = Paths.get("/", new String[0]);
        }
        Path svnProjectPath = SvnScmProvider.toPath(svnInfo.getURL());
        Path inRepoProjectPath = Paths.get("/", new String[0]).resolve(svnRootPath.relativize(svnProjectPath));
        HashSet<Path> paths = new HashSet<Path>();
        HashSet removed = new HashSet();
        SVNLogClient svnLogClient = clientManager.getLogClient();
        svnLogClient.doLog(new File[]{projectBasedir.toFile()}, null, null, null, true, true, 0L, svnLogEntry -> svnLogEntry.getChangedPaths().values().forEach(entry -> {
            if (entry.getKind().equals(SVNNodeKind.FILE)) {
                Path path = projectBasedir.resolve(inRepoProjectPath.relativize(Paths.get(entry.getPath(), new String[0])));
                if (SvnScmProvider.isModified(entry)) {
                    if (!removed.contains(path)) {
                        paths.add(path);
                    }
                } else if (entry.getType() == 'D') {
                    removed.add(path);
                }
            }
        }));
        return paths;
    }

    private static Path toPath(SVNURL svnUrl) {
        if ("file".equals(svnUrl.getProtocol())) {
            try {
                return Paths.get(new URL("file", svnUrl.getHost(), svnUrl.getPath()).toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return Paths.get(svnUrl.getURIEncodedPath(), new String[0]);
    }

    private static boolean isModified(SVNLogEntryPath entry) {
        return entry.getType() == 'A' || entry.getType() == 'M';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public Map<Path, Set<Integer>> branchChangedLines(String targetBranchName, Path rootBaseDir, Set<Path> changedFiles) {
        SVNClientManager clientManager = null;
        try {
            clientManager = SvnScmSupport.newSvnClientManager(this.configuration);
            SVNLogClient svnLogClient = clientManager.getLogClient();
            long[] revisionCounter = new long[]{0L};
            svnLogClient.doLog(new File[]{rootBaseDir.toFile()}, null, null, null, true, true, 0L, svnLogEntry -> {
                revisionCounter[0] = svnLogEntry.getRevision();
            });
            long startRev = revisionCounter[0];
            SVNDiffClient svnDiffClient = clientManager.getDiffClient();
            File path = rootBaseDir.toFile();
            ChangedLinesComputer computer = this.newChangedLinesComputer(rootBaseDir, changedFiles);
            svnDiffClient.doDiff(path, SVNRevision.create(startRev), path, SVNRevision.WORKING, SVNDepth.INFINITY, false, computer.receiver(), null);
            Map<Path, Set<Integer>> map = computer.changedLines();
            return map;
        }
        catch (Exception e) {
            LOG.warn("Failed to get changed lines from Subversion", e);
        }
        finally {
            if (clientManager != null) {
                try {
                    clientManager.dispose();
                }
                catch (Exception e) {
                    LOG.warn("Unable to dispose SVN ClientManager", e);
                }
            }
        }
        return null;
    }

    @Override
    @CheckForNull
    public Instant forkDate(String referenceBranch, Path rootBaseDir) {
        return null;
    }

    ChangedLinesComputer newChangedLinesComputer(Path rootBaseDir, Set<Path> changedFiles) {
        return new ChangedLinesComputer(rootBaseDir, changedFiles);
    }
}

